/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyAppsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneIdAware;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Generated;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="applications")
public class EzySimpleAppsSetting
implements EzyAppsSetting {
    protected final List<EzyAppSetting> apps = new ArrayList<EzyAppSetting>();
    protected final Map<Integer, EzySimpleAppSetting> appsByIds = new ConcurrentHashMap<Integer, EzySimpleAppSetting>();
    protected final Map<String, EzySimpleAppSetting> appsByNames = new ConcurrentHashMap<String, EzySimpleAppSetting>();

    @XmlElement(name="application")
    public void setItem(EzySimpleAppSetting item) {
        this.apps.add(item);
        this.appsByIds.put(item.getId(), item);
        this.appsByNames.put(item.getName(), item);
    }

    @Override
    public Set<String> getAppNames() {
        return this.appsByNames.keySet();
    }

    @Override
    public Set<Integer> getAppIds() {
        return this.appsByIds.keySet();
    }

    @Override
    public EzySimpleAppSetting getAppByName(String name) {
        EzySimpleAppSetting appSetting = this.appsByNames.get(name);
        if (appSetting != null) {
            return appSetting;
        }
        throw new IllegalArgumentException("has no app with name: " + name);
    }

    @Override
    public EzySimpleAppSetting getAppById(Integer id) {
        EzySimpleAppSetting appSetting = this.appsByIds.get(id);
        if (appSetting != null) {
            return appSetting;
        }
        throw new IllegalArgumentException("has no app with id: " + id);
    }

    @Override
    public int getSize() {
        return this.apps.size();
    }

    public void setZoneId(int zoneId) {
        this.apps.forEach(a -> ((EzyZoneIdAware)((Object)a)).setZoneId(zoneId));
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<Map> appMaps = new ArrayList<Map>();
        for (EzyAppSetting app : this.apps) {
            appMaps.add(app.toMap());
        }
        map.put("size", this.apps.size());
        map.put("apps", appMaps);
        return map;
    }

    @Override
    @Generated
    public List<EzyAppSetting> getApps() {
        return this.apps;
    }

    @Generated
    public Map<Integer, EzySimpleAppSetting> getAppsByIds() {
        return this.appsByIds;
    }

    @Generated
    public Map<String, EzySimpleAppSetting> getAppsByNames() {
        return this.appsByNames;
    }

    @Generated
    public String toString() {
        return "EzySimpleAppsSetting(apps=" + this.getApps() + ", appsByIds=" + this.getAppsByIds() + ", appsByNames=" + this.getAppsByNames() + ")";
    }
}

