/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.wrapper.impl;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.controller.EzyEventController;
import com.tvd12.ezyfoxserver.setting.EzyEventControllerSetting;
import com.tvd12.ezyfoxserver.setting.EzyEventControllersSetting;
import com.tvd12.ezyfoxserver.wrapper.EzyEventControllers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzyEventControllersImpl
implements EzyEventControllers {
    protected final Map<EzyConstant, List<EzyEventController>> controllers = new ConcurrentHashMap<EzyConstant, List<EzyEventController>>();

    public static EzyEventControllers create(EzyEventControllersSetting setting) {
        EzyEventControllersImpl controllers = new EzyEventControllersImpl();
        for (EzyEventControllerSetting item : setting.getEventControllers()) {
            controllers.addController(EzyEventType.valueOf(item.getEventType()), (EzyEventController)EzyClasses.newInstance((String)item.getController()));
        }
        return controllers;
    }

    @Override
    public void addController(EzyConstant eventType, EzyEventController controller) {
        this.controllers.compute(eventType, (k, v) -> {
            ArrayList<EzyEventController> list = v != null ? new ArrayList<EzyEventController>((Collection<EzyEventController>)v) : new ArrayList();
            list.add(controller);
            return list;
        });
    }

    @Override
    public List<EzyEventController> getControllers(EzyConstant eventType) {
        return this.controllers.getOrDefault(eventType, Collections.emptyList());
    }

    public void destroy() {
        this.controllers.clear();
    }
}

