/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.bash;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.File;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.bash.AdminCommandHandler;
import org.youngmonkeys.ezyplatform.admin.bash.Arguments;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;

public abstract class AbstractCommandHandler<A extends Arguments>
extends EzyLoggable
implements AdminCommandHandler<A> {
    @EzyAutoBind
    private AdminFileSystemManager fileSystemManager;

    protected void runCliCommand(String command, String arg) throws Exception {
        this.runBashFile("cli", command, arg);
    }

    protected void runBashFile(String file) throws Exception {
        this.runBashFile(file, null);
    }

    protected void runBashFile(String file, String command) throws Exception {
        this.runBashFile(file, command, null);
    }

    protected void runBashFile(String file, String command, String arg) throws Exception {
        String filePath;
        String commandLine = null;
        if (EzyStrings.isNotBlank((String)command)) {
            String string = commandLine = EzyStrings.isBlank((String)arg) ? command : command + " " + arg;
        }
        if (!new File(filePath = this.fileSystemManager.concatWithEzyHome(file + this.getBashFileExtension())).exists()) {
            throw new IllegalStateException("Not found bash file: " + filePath);
        }
        ProcessBuilder processBuilder = EzyStrings.isBlank((String)commandLine) ? new ProcessBuilder("bash", filePath) : new ProcessBuilder("bash", filePath, commandLine);
        Process process = processBuilder.start();
        process.waitFor();
    }

    private String getBashFileExtension() {
        return ".sh";
    }

    @Generated
    public void setFileSystemManager(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

