/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.io.EzyDates;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminEzyPlatformBackupWriter {
    private final AdminFileSystemManager fileSystemManager;

    public void backup() throws IOException {
        String nowTimeFolder = EzyDates.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd'T'HH-mm-ss");
        File backupRootFolder = Paths.get(this.fileSystemManager.getBackupFolder().toString(), nowTimeFolder).toFile();
        for (String filePath : this.getBackupFiles()) {
            File fromFile = this.fileSystemManager.concatWithEzyHome(Paths.get(filePath, new String[0]));
            if (!fromFile.exists()) continue;
            File toFile = Paths.get(backupRootFolder.toString(), filePath).toFile();
            if (fromFile.isFile()) {
                FolderProxy.copyFile((File)fromFile, (File)toFile);
                continue;
            }
            FolderProxy.copyFolder((File)fromFile, (File)toFile);
        }
    }

    private Set<String> getBackupFiles() throws IOException {
        File updateFilesPath = this.fileSystemManager.getNewEzyPlatformUpdateFilesFile();
        if (!updateFilesPath.exists()) {
            throw new ResourceNotFoundException("update-files.txt");
        }
        Set answer = Sets.newHashSet((Object[])new String[]{"update.sh", "tools"});
        try (Stream<String> stream = Files.lines(updateFilesPath.toPath());){
            answer.addAll(stream.filter(it -> it.length() > 0).collect(Collectors.toSet()));
        }
        return answer;
    }

    @Generated
    public AdminEzyPlatformBackupWriter(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

