/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyReturner;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.GetRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;

@EzySingleton
public class AdminWebFeatureUriManager
extends EzyLoggable {
    private final HttpClient httpClient;
    private final AdminSettingService settingService;
    private final AtomicReference<Map<String, Map<String, List<HttpMethod>>>> webUrisByFeatureMapRef = new AtomicReference();

    public Map<String, Map<String, List<HttpMethod>>> getURIsByFeatureMap(String adminAccessToken) {
        try {
            Map response = (Map)this.httpClient.call((Request)((GetRequest)((GetRequest)new GetRequest().setEntity(RequestEntity.builder().header("adminAccessToken", adminAccessToken).build())).setURL(this.settingService.resolveWebUri("/api/v1/web/features"))).setResponseType(Map.class));
            Map<String, Map<String, List<HttpMethod>>> result = response.entrySet().stream().filter(e -> !"devops".equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ue -> ((List)ue.getValue()).stream().map(HttpMethod::valueOf).collect(Collectors.toList())))));
            this.webUrisByFeatureMapRef.set(result);
            return result;
        }
        catch (Exception e2) {
            this.logger.warn("ca not get web uris feature map", (Throwable)e2);
            return Collections.emptyMap();
        }
    }

    public Map<String, Map<String, List<HttpMethod>>> getCachedURIsByFeatureMap() {
        return (Map)EzyReturner.returnNotNull(this.webUrisByFeatureMapRef.get(), Collections.emptyMap());
    }

    @Generated
    public AdminWebFeatureUriManager(HttpClient httpClient, AdminSettingService settingService) {
        this.httpClient = httpClient;
        this.settingService = settingService;
    }
}

