/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.binding.annotation.EzyValue;
import com.tvd12.ezyfox.binding.impl.EzyAbstractElementsFetcher;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import java.util.ArrayList;
import java.util.List;

public abstract class EzyObjectElementsFetcher
extends EzyAbstractElementsFetcher {
    @Override
    protected List<Object> doGetElements(EzyClass clazz, int accessType) {
        return accessType == 0 ? this.getAnnotatedElements(clazz) : this.getNativeElements(clazz, accessType);
    }

    private List<Object> getAnnotatedElements(EzyClass clazz) {
        return this.getAnnotatedElements(this.getAnnotatedFields(clazz), this.getAnnotatedMethods(clazz));
    }

    private List<Object> getAnnotatedElements(List<EzyField> fields, List<? extends EzyMethod> methods) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (EzyField ezyField : fields) {
            this.logger.debug("scan field {}", (Object)ezyField.getName());
            EzyMethod method = (EzyMethod)this.methodsByFieldName.get(ezyField.getName());
            if (method != null) {
                if (!this.isValidGenericMethod(method)) {
                    this.logger.debug("unknown generic type of method {}, ignore it", (Object)method.getName());
                    continue;
                }
                elements.add(method);
                methods.remove(method);
                continue;
            }
            if (ezyField.isPublic()) {
                if (!this.isValidGenericField(ezyField)) {
                    this.logger.debug("unknown generic type of field {}, ignore it", (Object)ezyField.getName());
                    continue;
                }
                elements.add(ezyField);
                continue;
            }
            this.logger.debug("field {} has not getter/setter, ignore it", (Object)ezyField.getName());
        }
        for (EzyMethod ezyMethod : methods) {
            this.logger.debug("scan method {}", (Object)ezyMethod.getName());
            if (this.isValidGenericMethod(ezyMethod)) {
                elements.add(ezyMethod);
                continue;
            }
            this.logger.debug("unknown generic type of method {}, ignore it", (Object)ezyMethod.getName());
        }
        return elements;
    }

    private List<Object> getNativeElements(EzyClass clazz, int accessType) {
        return this.getNativeElements(this.getFields(clazz, accessType), this.getMethods(clazz, accessType));
    }

    private List<Object> getNativeElements(List<EzyField> fields, List<? extends EzyMethod> methods) {
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<? extends EzyMethod> remainMethods = new ArrayList<EzyMethod>(methods);
        for (EzyField ezyField : fields) {
            this.logger.debug("scan field {}", (Object)ezyField.getName());
            EzyMethod method = (EzyMethod)this.methodsByFieldName.get(ezyField.getName());
            if (method != null) {
                if (this.isValidGenericMethod(method)) {
                    elements.add(method);
                } else {
                    this.logger.debug("unknown generic type of method {}, ignore it", (Object)method.getName());
                }
                remainMethods.remove(method);
                continue;
            }
            if (ezyField.isPublic()) {
                if (this.isValidGenericField(ezyField)) {
                    elements.add(ezyField);
                    continue;
                }
                this.logger.debug("unknown generic type of field {}, ignore it", (Object)ezyField.getName());
                continue;
            }
            this.logger.debug("field {} has not getter/setter, ignore it", (Object)ezyField.getName());
        }
        for (EzyMethod ezyMethod : remainMethods) {
            this.logger.debug("scan method {}", (Object)ezyMethod.getName());
            if (this.isValidGenericMethod(ezyMethod)) {
                elements.add(ezyMethod);
                continue;
            }
            this.logger.debug("unknown generic type of method {}, ignore it", (Object)ezyMethod.getName());
        }
        return elements;
    }

    private List<EzyField> getAnnotatedFields(EzyClass clazz) {
        return clazz.getFields(f -> f.isAnnotated(EzyValue.class));
    }

    @Override
    protected boolean shouldAddAnnotatedMethod(EzyMethod method) {
        return method.isPublic() && method.isAnnotated(EzyValue.class) && this.isValidAnnotatedMethod(method);
    }

    protected abstract boolean isValidAnnotatedMethod(EzyMethod var1);
}

