/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.jetty;

import com.tvd12.ezyfox.annotation.EzyProperty;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStoppable;
import com.tvd12.ezyhttp.core.util.FileSizes;
import com.tvd12.ezyhttp.server.core.ApplicationEntry;
import com.tvd12.ezyhttp.server.core.annotation.ApplicationBootstrap;
import com.tvd12.ezyhttp.server.jetty.JettyBlockingServlet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import lombok.Generated;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@ApplicationBootstrap
public class JettyApplicationBootstrap
extends EzyLoggable
implements ApplicationEntry,
EzyStoppable {
    @EzyProperty(value="server.port")
    protected int port = 8080;
    @EzyProperty(value="server.host")
    protected String host = "0.0.0.0";
    @EzyProperty(value="server.max_threads")
    protected int maxThreads = 16;
    @EzyProperty(value="server.min_threads")
    protected int minThreads = 4;
    @EzyProperty(value="server.idle_timeout")
    protected int idleTimeout = 150000;
    @EzyProperty(value="server.max_request_body_size")
    protected String maxRequestBodySize = "2MB";
    @EzyProperty(value="server.multipart.location")
    protected String multipartLocation = System.getProperty("java.io.tmpdir");
    @EzyProperty(value="server.multipart.file_size_threshold")
    protected String multipartFileSizeThreshold = "1MB";
    @EzyProperty(value="server.multipart.max_file_size")
    protected String multipartMaxFileSize = "5MB";
    @EzyProperty(value="server.multipart.max_request_size")
    protected String multipartMaxRequestSize = "5MB";
    @EzyProperty(value="server.compression.enable")
    protected boolean compressionEnable = true;
    @EzyProperty(value="server.compression.min_size")
    protected String compressionMinSize;
    @EzyProperty(value="server.compression.included_methods")
    protected String[] compressionIncludedMethods;
    @EzyProperty(value="server.compression.excluded_methods")
    protected String[] compressionExcludedMethods;
    @EzyProperty(value="server.compression.included_mime_types")
    protected String[] compressionIncludedMimeTypes;
    @EzyProperty(value="server.compression.excluded_mime_types")
    protected String[] compressionExcludedMimeTypes;
    @EzyProperty(value="cors.enable")
    protected boolean corsEnable;
    @EzyProperty(value="cors.allowed_origins")
    protected String allowedOrigins = "*";
    @EzyProperty(value="cors.allowed_headers")
    protected String allowedHeaders = "*";
    @EzyProperty(value="management.enable")
    protected boolean managementEnable;
    @EzyProperty(value="management.host")
    protected String managementHost = "0.0.0.0";
    @EzyProperty(value="management.port")
    protected int managementPort = 18080;
    protected Server server;

    public void start() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.maxThreads, this.minThreads, this.idleTimeout);
        this.server = new Server((ThreadPool)threadPool);
        List<Connector> connectors = this.createConnectors();
        this.server.setConnectors(connectors.toArray(new Connector[0]));
        ServletContextHandler servletHandler = this.newServletHandler();
        if (this.compressionEnable) {
            GzipHandler gzipHandler = this.newGzipHandler();
            gzipHandler.setHandler((Handler)servletHandler);
            servletHandler = gzipHandler;
        }
        this.server.setHandler((Handler)servletHandler);
        this.server.start();
        this.logger.info("http server started on: {}:{}", (Object)this.host, (Object)this.port);
        if (this.managementEnable) {
            this.logger.info("management started on: {}:{}", (Object)this.managementHost, (Object)this.managementPort);
        }
    }

    private List<Connector> createConnectors() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setHost(this.host);
        connector.setPort(this.port);
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        connectors.add((Connector)connector);
        if (this.managementEnable) {
            ServerConnector managementConnector = new ServerConnector(this.server);
            managementConnector.setHost(this.managementHost);
            managementConnector.setPort(this.managementPort);
            connectors.add((Connector)managementConnector);
        }
        return connectors;
    }

    protected ServletContextHandler newServletHandler() {
        ServletContextHandler servletHandler = new ServletContextHandler();
        servletHandler.addServlet(JettyBlockingServlet.class, "/*").getRegistration().setMultipartConfig(new MultipartConfigElement(this.multipartLocation, FileSizes.toByteSize((String)this.multipartMaxFileSize), (long)((int)FileSizes.toByteSize((String)this.multipartMaxRequestSize)), (int)FileSizes.toByteSize((String)this.multipartFileSizeThreshold)));
        servletHandler.setMaxFormContentSize((int)FileSizes.toByteSize((String)this.maxRequestBodySize));
        this.logger.info("cors.enable = {}", (Object)this.corsEnable);
        if (this.corsEnable) {
            this.addFilter(servletHandler, this.newCrossOriginFilter());
        }
        return servletHandler;
    }

    protected GzipHandler newGzipHandler() {
        GzipHandler gzipHandler = new GzipHandler();
        if (EzyStrings.isNotEmpty((CharSequence)this.compressionMinSize)) {
            gzipHandler.setMinGzipSize((int)FileSizes.toByteSize((String)this.compressionMinSize));
        }
        if (this.compressionIncludedMethods != null) {
            gzipHandler.setIncludedMethods(this.compressionIncludedMethods);
        }
        if (this.compressionExcludedMethods != null) {
            gzipHandler.setExcludedMethods(this.compressionExcludedMethods);
        }
        if (this.compressionIncludedMimeTypes != null) {
            gzipHandler.setIncludedMimeTypes(this.compressionIncludedMimeTypes);
        }
        if (this.compressionExcludedMimeTypes != null) {
            gzipHandler.setExcludedMimeTypes(this.compressionExcludedMimeTypes);
        }
        return gzipHandler;
    }

    protected void addFilter(ServletContextHandler servletHandler, FilterHolder filter) {
        servletHandler.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    protected FilterHolder newCrossOriginFilter() {
        FilterHolder filter = new FilterHolder();
        filter.setName("cross-origin");
        filter.setInitParameter("allowedOrigins", this.allowedOrigins);
        filter.setInitParameter("allowedMethods", "GET,HEAD,POST,PUT,DELETE,CONNECT,TRACE,PATCH,OPTIONS");
        filter.setInitParameter("allowedHeaders", this.allowedHeaders);
        filter.setInitParameter("Access-Control-Allow-Origin", this.allowedOrigins);
        filter.setInitParameter("Access-Control-Allow-Methods", "GET,HEAD,POST,PUT,DELETE,CONNECT,TRACE,PATCH,OPTIONS");
        filter.setInitParameter("Access-Control-Allow-Headers", this.allowedHeaders);
        CrossOriginFilter corsFilter = new CrossOriginFilter();
        filter.setFilter((Filter)corsFilter);
        return filter;
    }

    public void stop() {
        if (this.server != null) {
            EzyProcessor.processWithLogException(() -> ((Server)this.server).stop());
        }
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Generated
    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    @Generated
    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Generated
    public void setMaxRequestBodySize(String maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
    }

    @Generated
    public void setMultipartLocation(String multipartLocation) {
        this.multipartLocation = multipartLocation;
    }

    @Generated
    public void setMultipartFileSizeThreshold(String multipartFileSizeThreshold) {
        this.multipartFileSizeThreshold = multipartFileSizeThreshold;
    }

    @Generated
    public void setMultipartMaxFileSize(String multipartMaxFileSize) {
        this.multipartMaxFileSize = multipartMaxFileSize;
    }

    @Generated
    public void setMultipartMaxRequestSize(String multipartMaxRequestSize) {
        this.multipartMaxRequestSize = multipartMaxRequestSize;
    }

    @Generated
    public void setCompressionEnable(boolean compressionEnable) {
        this.compressionEnable = compressionEnable;
    }

    @Generated
    public void setCompressionMinSize(String compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    @Generated
    public void setCompressionIncludedMethods(String[] compressionIncludedMethods) {
        this.compressionIncludedMethods = compressionIncludedMethods;
    }

    @Generated
    public void setCompressionExcludedMethods(String[] compressionExcludedMethods) {
        this.compressionExcludedMethods = compressionExcludedMethods;
    }

    @Generated
    public void setCompressionIncludedMimeTypes(String[] compressionIncludedMimeTypes) {
        this.compressionIncludedMimeTypes = compressionIncludedMimeTypes;
    }

    @Generated
    public void setCompressionExcludedMimeTypes(String[] compressionExcludedMimeTypes) {
        this.compressionExcludedMimeTypes = compressionExcludedMimeTypes;
    }

    @Generated
    public void setCorsEnable(boolean corsEnable) {
        this.corsEnable = corsEnable;
    }

    @Generated
    public void setAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    @Generated
    public void setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    @Generated
    public void setManagementEnable(boolean managementEnable) {
        this.managementEnable = managementEnable;
    }

    @Generated
    public void setManagementHost(String managementHost) {
        this.managementHost = managementHost;
    }

    @Generated
    public void setManagementPort(int managementPort) {
        this.managementPort = managementPort;
    }
}

