/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.api;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.MediaStatus;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultMediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.util.StringConverters;
import org.youngmonkeys.ezyplatform.web.annotation.UserId;
import org.youngmonkeys.ezyplatform.web.controller.service.WebMediaControllerService;
import org.youngmonkeys.ezyplatform.web.response.MediaDetailsResponse;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;
import org.youngmonkeys.ezyplatform.web.validator.WebMediaValidator;

@Authenticated
public class WebApiMediaDetailsController {
    @EzyAutoBind
    protected WebSettingService settingService;
    @EzyAutoBind
    protected WebMediaControllerService mediaControllerService;
    @EzyAutoBind
    protected WebMediaValidator mediaValidator;

    @Async
    @DoPost(value="/media/add")
    public void mediaAddPost(HttpServletRequest request, HttpServletResponse response, @UserId long userId, @RequestParam(value="avatar") boolean avatar, @RequestParam(value="notPublic") boolean notPublic) throws Exception {
        this.mediaControllerService.addMedia(request, response, UploadFrom.USER.toString(), 0L, userId, avatar, notPublic);
    }

    @Async
    @DoPost(value="/media/{id}/replace")
    public void mediaIdReplacePost(HttpServletRequest request, HttpServletResponse response, @UserId long userId, @PathVariable long mediaId) throws Exception {
        this.mediaControllerService.replaceMedia(request, response, mediaId, media -> media.getOwnerUserId() == userId);
    }

    @Async
    @DoPost(value="/media/{name}/replace-by-name")
    public void mediaNameReplaceByNamePost(HttpServletRequest request, HttpServletResponse response, @UserId long userId, @PathVariable String mediaName) throws Exception {
        this.mediaControllerService.replaceMedia(request, response, mediaName, media -> media.getOwnerUserId() == userId);
    }

    @DoPut(value="/media/{name}")
    public ResponseEntity mediaNamePut(@UserId long userId, @PathVariable String mediaName, @RequestBody UpdateMediaRequest request) {
        this.mediaControllerService.updateMedia(mediaName, request, media -> media.getOwnerUserId() == userId);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/media/{name}")
    public ResponseEntity mediaNameDelete(@UserId long userId, @PathVariable String mediaName) {
        this.mediaValidator.validateOwnerUserMedia(userId, mediaName);
        this.mediaControllerService.removeMediaByName(mediaName, Boolean.TRUE);
        return ResponseEntity.noContent();
    }

    @DoGet(value="/media/{name}/details")
    public MediaDetailsResponse mediaNameDetailsGet(@UserId long userId, @PathVariable String name) {
        return this.mediaControllerService.getWebMediaDetailsByName(name, media -> media.getOwnerUserId() == userId);
    }

    @DoGet(value="/media/list")
    public PaginationModel<MediaResponse> mediaListGet(@UserId long userId, @RequestParam(value="type") String type, @RequestParam(value="status") String status, @RequestParam(value="keyword") String keyword, @RequestParam(value="sortOrder") String sortOrder, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        String trimedStatus = StringConverters.trimOrNull((String)status);
        String trimmedKeyword = StringConverters.trimOrNull((String)keyword);
        return this.mediaControllerService.getMediaList((MediaFilter)DefaultMediaFilter.builder().type(StringConverters.trimOrNull((String)type)).status(trimedStatus).exclusiveStatus(trimedStatus == null ? MediaStatus.REMOVED.toString() : CommonConstants.NULL_STRING).allowSearchByLikeOperator(this.settingService.isAllowSearchMediaByLikeOperator()).prefixKeyword(trimmedKeyword).likeKeyword(trimmedKeyword).ownerUserId(Long.valueOf(userId)).build(), sortOrder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @Generated
    public void setSettingService(WebSettingService settingService) {
        this.settingService = settingService;
    }

    @Generated
    public void setMediaControllerService(WebMediaControllerService mediaControllerService) {
        this.mediaControllerService = mediaControllerService;
    }

    @Generated
    public void setMediaValidator(WebMediaValidator mediaValidator) {
        this.mediaValidator = mediaValidator;
    }
}

