/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioUdpDataHandler;
import com.tvd12.ezyfoxserver.nio.handler.EzySimpleNioUdpDataHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzySocketDataReceiver;
import com.tvd12.ezyfoxserver.nio.udp.EzyNioUdpReader;
import com.tvd12.ezyfoxserver.nio.udp.EzyNioUdpReadingLoopHandler;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.setting.EzyUdpSetting;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelPool;
import com.tvd12.ezyfoxserver.socket.EzySocketEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketEventLoopHandler;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;

public class EzyUdpServerBootstrap
implements EzyStartable,
EzyDestroyable {
    private Selector readSelector;
    private final EzyServer server;
    private final EzyUdpSetting udpSetting;
    private final EzySocketDataReceiver socketDataReceiver;
    private final EzyHandlerGroupManager handlerGroupManager;
    private final EzyDatagramChannelPool udpChannelPool;
    private final EzyNioUdpDataHandler udpDataHandler;
    private EzySocketEventLoopHandler readingLoopHandler;

    public EzyUdpServerBootstrap(Builder builder) {
        EzyServerContext serverContext = builder.serverContext;
        this.server = serverContext.getServer();
        this.udpSetting = this.server.getSettings().getUdp();
        this.socketDataReceiver = builder.socketDataReceiver;
        this.handlerGroupManager = builder.handlerGroupManager;
        this.udpChannelPool = this.newChannelPool();
        this.udpDataHandler = this.newUdpDataHandler();
        serverContext.setProperty(EzyNioUdpDataHandler.class, (Object)this.udpDataHandler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() throws Exception {
        this.openSelectors();
        this.configChannelPool();
        this.startSocketHandlers();
    }

    public void destroy() {
        EzyProcessor.processWithLogException(() -> ((EzySocketEventLoopHandler)this.readingLoopHandler).destroy());
        EzyProcessor.processWithLogException(() -> ((EzyDatagramChannelPool)this.udpChannelPool).close());
    }

    private void openSelectors() throws Exception {
        this.readSelector = this.openSelector();
    }

    private EzyDatagramChannelPool newChannelPool() {
        return new EzyDatagramChannelPool(this.udpSetting.getChannelPoolSize());
    }

    private void configChannelPool() {
        this.udpChannelPool.bind(new InetSocketAddress(this.udpSetting.getAddress(), this.udpSetting.getPort()));
        this.udpChannelPool.register(this.readSelector);
    }

    private void startSocketHandlers() throws Exception {
        this.readingLoopHandler = this.newReadingLoopHandler();
        this.readingLoopHandler.start();
    }

    private EzySocketEventLoopHandler newReadingLoopHandler() {
        EzyNioUdpReadingLoopHandler loopHandler = new EzyNioUdpReadingLoopHandler();
        loopHandler.setThreadPoolSize(this.getSocketReaderPoolSize());
        EzyNioUdpReader eventHandler = new EzyNioUdpReader(this.udpSetting.getMaxRequestSize());
        eventHandler.setOwnSelector(this.readSelector);
        eventHandler.setUdpDataHandler(this.udpDataHandler);
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private EzyNioUdpDataHandler newUdpDataHandler() {
        EzySimpleNioUdpDataHandler handler = new EzySimpleNioUdpDataHandler(this.udpSetting.getHandlerThreadPoolSize());
        handler.setResponseApi(this.server.getResponseApi());
        handler.setDatagramChannelPool(this.udpChannelPool);
        handler.setSessionManager(this.server.getSessionManager());
        handler.setSocketDataReceiver(this.socketDataReceiver);
        handler.setHandlerGroupManager(this.handlerGroupManager);
        return handler;
    }

    private Selector openSelector() throws Exception {
        return Selector.open();
    }

    private int getSocketReaderPoolSize() {
        return 1;
    }

    public static class Builder
    implements EzyBuilder<EzyUdpServerBootstrap> {
        private EzyServerContext serverContext;
        private EzySocketDataReceiver socketDataReceiver;
        private EzyHandlerGroupManager handlerGroupManager;

        public Builder serverContext(EzyServerContext context) {
            this.serverContext = context;
            return this;
        }

        public Builder socketDataReceiver(EzySocketDataReceiver socketDataReceiver) {
            this.socketDataReceiver = socketDataReceiver;
            return this;
        }

        public Builder handlerGroupManager(EzyHandlerGroupManager manager) {
            this.handlerGroupManager = manager;
            return this;
        }

        public EzyUdpServerBootstrap build() {
            return new EzyUdpServerBootstrap(this);
        }
    }
}

