/*
 * Decompiled with CFR 0.152.
 */
package com.ezyplatform.socket.monitor.plugin.data;

import com.tvd12.ezyfox.binding.annotation.EzyObjectBinding;

@EzyObjectBinding(read=false)
public class CpuPoint {
    private double systemCpuLoad;
    private double processCpuLoad;
    private double processGcActivity;

    CpuPoint(double systemCpuLoad, double processCpuLoad, double processGcActivity) {
        this.systemCpuLoad = systemCpuLoad;
        this.processCpuLoad = processCpuLoad;
        this.processGcActivity = processGcActivity;
    }

    public static CpuPointBuilder builder() {
        return new CpuPointBuilder();
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoad;
    }

    public double getProcessGcActivity() {
        return this.processGcActivity;
    }

    public static class CpuPointBuilder {
        private double systemCpuLoad;
        private double processCpuLoad;
        private double processGcActivity;

        CpuPointBuilder() {
        }

        public CpuPointBuilder systemCpuLoad(double systemCpuLoad) {
            this.systemCpuLoad = systemCpuLoad;
            return this;
        }

        public CpuPointBuilder processCpuLoad(double processCpuLoad) {
            this.processCpuLoad = processCpuLoad;
            return this;
        }

        public CpuPointBuilder processGcActivity(double processGcActivity) {
            this.processGcActivity = processGcActivity;
            return this;
        }

        public CpuPoint build() {
            return new CpuPoint(this.systemCpuLoad, this.processCpuLoad, this.processGcActivity);
        }

        public String toString() {
            return "CpuPoint.CpuPointBuilder(systemCpuLoad=" + this.systemCpuLoad + ", processCpuLoad=" + this.processCpuLoad + ", processGcActivity=" + this.processGcActivity + ")";
        }
    }
}

