/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.thymeleaf;

import com.tvd12.ezyhttp.server.core.view.ViewTemplateInputStreamLoader;
import com.tvd12.ezyhttp.server.thymeleaf.ThymeleafTemplateResourceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.thymeleaf.templateresource.ClassLoaderTemplateResource;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class ThymeleafClassLoaderTemplateResource
implements ITemplateResource {
    private final String template;
    private final String path;
    private final String characterEncoding;
    private final List<ViewTemplateInputStreamLoader> templateInputStreamLoaders;

    public ThymeleafClassLoaderTemplateResource(String template, String path, String characterEncoding, List<ViewTemplateInputStreamLoader> templateInputStreamLoaders) {
        Validate.notEmpty((String)path, (String)"Resource Path cannot be null or empty");
        this.template = template;
        String cleanPath = ThymeleafTemplateResourceUtils.cleanPath(path);
        this.path = cleanPath.charAt(0) == '/' ? cleanPath.substring(1) : cleanPath;
        this.characterEncoding = characterEncoding;
        this.templateInputStreamLoaders = templateInputStreamLoaders;
    }

    public String getDescription() {
        return this.path;
    }

    public String getBaseName() {
        return ThymeleafTemplateResourceUtils.computeBaseName(this.path);
    }

    public Reader reader() throws IOException {
        InputStream inputStream = ClassLoaderUtils.findResourceAsStream((String)this.path);
        if (inputStream == null) {
            ViewTemplateInputStreamLoader loader;
            Iterator<ViewTemplateInputStreamLoader> iterator = this.templateInputStreamLoaders.iterator();
            while (iterator.hasNext() && (inputStream = (loader = iterator.next()).load(this.template, this.path)) == null) {
            }
        }
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("ClassLoader resource \"%s\" could not be resolved", this.path));
        }
        if (!StringUtils.isEmptyOrWhitespace((String)this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    public ITemplateResource relative(String relativeLocation) {
        Validate.notEmpty((String)relativeLocation, (String)"Relative Path cannot be null or empty");
        String fullRelativeLocation = ThymeleafTemplateResourceUtils.computeRelativeLocation(this.path, relativeLocation);
        return new ClassLoaderTemplateResource(null, fullRelativeLocation, this.characterEncoding);
    }

    public boolean exists() {
        return ClassLoaderUtils.isResourcePresent((String)this.path);
    }
}

