/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.reader;

import com.tvd12.properties.file.exception.PropertiesFileException;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MultiFileReader
extends BaseFileReader {
    private final List<String> includeProfiles = new ArrayList<String>();

    public MultiFileReader() {
        this("");
    }

    public MultiFileReader(String includeProfiles) {
        this(MultiFileReader.getIncludeProfiles(includeProfiles));
    }

    public MultiFileReader(List<String> includeProfiles) {
        this.includeProfiles.addAll(includeProfiles);
    }

    @Override
    public Properties read(ClassLoader classLoader, String filePath) {
        Properties answer = this.read(classLoader, filePath, new HashSet<String>());
        answer.remove("include.profiles");
        return answer;
    }

    private Properties read(ClassLoader classLoader, String filePath, Set<String> passedFilePaths) {
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(filePath);
        for (String profile : this.includeProfiles) {
            filePaths.add(FileUtil.getFileClasspathByProfile(filePath, profile));
        }
        filePaths.removeAll(passedFilePaths);
        Properties properties = new Properties();
        for (String fp : filePaths) {
            Properties prop;
            if (passedFilePaths.contains(fp)) continue;
            try {
                prop = super.read(classLoader, fp);
            }
            catch (PropertiesFileException e) {
                continue;
            }
            passedFilePaths.add(fp);
            properties.putAll((Map<?, ?>)prop);
            String profilesString = prop.getProperty("include.profiles");
            List<String> profiles = MultiFileReader.getIncludeProfiles(profilesString);
            if (profiles.size() <= 0) continue;
            properties.putAll((Map<?, ?>)new MultiFileReader(profiles).read(classLoader, filePath, passedFilePaths));
        }
        return properties;
    }

    @Override
    public Properties read(File file) {
        Properties answer = this.read(file, new HashSet<File>());
        answer.remove("include.profiles");
        return answer;
    }

    private Properties read(File file, Set<File> passedFiles) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        for (String profile : this.includeProfiles) {
            files.add(FileUtil.getFileSytemByProfile(file, profile));
        }
        files.removeAll(passedFiles);
        Properties properties = new Properties();
        for (File f : files) {
            if (passedFiles.contains(f)) continue;
            Properties prop = super.read(f);
            passedFiles.add(f);
            properties.putAll((Map<?, ?>)prop);
            String profilesString = prop.getProperty("include.profiles");
            List<String> profiles = MultiFileReader.getIncludeProfiles(profilesString);
            if (profiles.size() <= 0) continue;
            properties.putAll((Map<?, ?>)new MultiFileReader(profiles).read(file, passedFiles));
        }
        return properties;
    }

    private static List<String> getIncludeProfiles(String profilesString) {
        String[] profiles;
        ArrayList<String> answer = new ArrayList<String>();
        if (profilesString == null) {
            return answer;
        }
        for (String profile : profiles = profilesString.split(",")) {
            if (profile.trim().length() <= 0) continue;
            answer.add(profile);
        }
        return answer;
    }
}

