/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataAppender;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataCountIncrementer;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.repo.AdminDataRecordCountRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.entity.DataRecordCount;
import org.youngmonkeys.ezyplatform.model.IncreaseDataRecordCountModel;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

@EzySingleton
public class AdminDataCountAppender
extends AdminDataAppender<DataRecordCount, DataRecordCount, Void> {
    private final ClockProxy clock;
    private final EzySingletonFactory singletonFactory;
    private final AdminDataRecordCountRepository dataRecordCountRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private List<AdminDataCountIncrementer> dataCountIncrementers;

    public AdminDataCountAppender(ClockProxy clock, EzySingletonFactory singletonFactory, ObjectMapper objectMapper, AdminSettingService settingService, AdminDataRecordCountRepository dataRecordCountRepository, AdminModelToEntityConverter modelToEntityConverter) {
        super(objectMapper, settingService);
        this.clock = clock;
        this.singletonFactory = singletonFactory;
        this.dataRecordCountRepository = dataRecordCountRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }

    @Override
    protected boolean defaultStarted() {
        return true;
    }

    protected void initDataCountIncrementers() {
        if (this.dataCountIncrementers == null) {
            this.dataCountIncrementers = this.singletonFactory.getSingletonsOf(AdminDataCountIncrementer.class);
        }
    }

    @Override
    protected void doAppend() {
        this.initDataCountIncrementers();
        LocalDateTime now = this.clock.nowDateTime();
        Iterator<AdminDataCountIncrementer> iterator = this.dataCountIncrementers.iterator();
        while (iterator.hasNext()) {
            AdminDataCountIncrementer incrementer;
            String dataType = (incrementer = iterator.next()).getDataType();
            IdResult lastRecordIdResult = this.dataRecordCountRepository.findLastRecordIdByDataType(dataType);
            long lastRecordId = lastRecordIdResult != null ? lastRecordIdResult.getId() : 0L;
            IncreaseDataRecordCountModel model = incrementer.incrementDataRecordCount(lastRecordId);
            long value = model.getValue();
            if (value == 0L) continue;
            DataRecordCount entity = (DataRecordCount)this.dataRecordCountRepository.findById(dataType);
            if (entity == null) {
                entity = this.modelToEntityConverter.toNewDataRecordCount(dataType);
            }
            entity.setRecordCount(entity.getRecordCount() + value);
            long newLastRecordId = model.getLastRecordId();
            entity.setLastRecordId(newLastRecordId);
            entity.setLastCountedAt(now);
            this.dataRecordCountRepository.save(entity);
            this.logger.info("increase data count records: {} for: {}, newLastRecordId: {}", new Object[]{value, dataType, newLastRecordId});
        }
    }

    @Override
    protected List<DataRecordCount> getValueList(Void unused) {
        throw new UnsupportedOperationException("unused");
    }

    @Override
    protected Void extractNewLastPageToken(List<DataRecordCount> list, Void unused) {
        throw new UnsupportedOperationException("unused");
    }

    @Override
    public void reload() {
        this.initDataCountIncrementers();
        for (AdminDataCountIncrementer incrementer : this.dataCountIncrementers) {
            incrementer.reload();
        }
        super.reload();
    }

    @Override
    protected String getAppenderNamePrefix() {
        return "data_record_counts";
    }

    @Override
    public String getAppenderStartedSettingName() {
        return "admin_data_count_appender_started";
    }

    @Override
    protected Void defaultPageToken() {
        throw new UnsupportedOperationException("unused");
    }

    @Override
    protected Class<Void> pageTokenType() {
        return Void.class;
    }
}

