/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyfox.util.Next;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataAppender;
import org.youngmonkeys.ezyplatform.admin.extractor.AdminUserKeywordsExtractor;
import org.youngmonkeys.ezyplatform.admin.repo.AdminUserRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserKeywordService;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.model.AddUserKeywordModel;
import org.youngmonkeys.ezyplatform.pagination.LastUpdatedAtPageToken;

@EzySingleton
public class AdminUserIndexAppender
extends AdminDataAppender<User, AddUserKeywordModel, LastUpdatedAtPageToken> {
    private final AdminUserKeywordsExtractor userKeywordsExtractor;
    private final AdminUserRepository userRepository;
    private final AdminUserKeywordService userKeywordService;

    public AdminUserIndexAppender(ObjectMapper objectMapper, AdminUserKeywordsExtractor userKeywordsExtractor, AdminSettingService settingService, AdminUserKeywordService userKeywordService, AdminUserRepository userRepository) {
        super(objectMapper, settingService);
        this.userKeywordsExtractor = userKeywordsExtractor;
        this.userKeywordService = userKeywordService;
        this.userRepository = userRepository;
    }

    @Override
    protected boolean defaultStarted() {
        return true;
    }

    @Override
    protected void addDataRecords(List<AddUserKeywordModel> dataRecords) {
        this.userKeywordService.addUserKeywords(dataRecords);
    }

    @Override
    protected Set<AddUserKeywordModel> toDataRecords(User value) {
        long userId = value.getId();
        Set keywords = this.userKeywordsExtractor.extract(value);
        this.logger.info("process user: {}, keywords: {}", (Object)userId, (Object)keywords);
        return EzySets.newHashSet((Collection)keywords, keyword -> AddUserKeywordModel.builder().userId(userId).keyword(keyword).priority(keyword.length()).build());
    }

    @Override
    protected List<User> getValueList(LastUpdatedAtPageToken pageToken) {
        return this.userRepository.findUsersByUpdatedAtAndIdPaginationAsc(pageToken.getUpdatedAt(), pageToken.getIdNumber(), Next.limit((long)pageToken.getLimit()));
    }

    @Override
    protected LastUpdatedAtPageToken extractNewLastPageToken(List<User> valueList, LastUpdatedAtPageToken currentLastPageToken) {
        return currentLastPageToken.newLastPageToken(valueList.size(), () -> this.extractLastUpdatedAt((User)EzyLists.last((List)valueList)), () -> this.extractLastId((User)EzyLists.last((List)valueList)));
    }

    protected LocalDateTime extractLastUpdatedAt(User value) {
        return value.getUpdatedAt();
    }

    protected Object extractLastId(User value) {
        return value.getId();
    }

    @Override
    protected LastUpdatedAtPageToken defaultPageToken() {
        return LastUpdatedAtPageToken.defaultPageToken((LocalDateTime)this.firstUpdatedAt());
    }

    protected LocalDateTime firstUpdatedAt() {
        return CommonConstants.MIN_SQL_DATETIME;
    }

    @Override
    protected Class<LastUpdatedAtPageToken> pageTokenType() {
        return LastUpdatedAtPageToken.class;
    }

    @Override
    protected String getAppenderNamePrefix() {
        return "ezyplatform_users_keywords";
    }
}

