/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminAdminTokenControllerService;
import org.youngmonkeys.ezyplatform.admin.request.RquiredPasswordRequest;
import org.youngmonkeys.ezyplatform.admin.response.AdminAccessTokenResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminAuthenticationValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminAccessToken;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiAuthenticationController {
    private final AdminSettingService settingService;
    private final AdminAdminTokenControllerService adminTokenControllerService;
    private final AdminAuthenticationValidator authenticationValidator;

    @DoPut(value="/admins/me/access-token/renew")
    public ResponseEntity adminsMeAccessTokenRenewPost(HttpServletResponse response, @AdminAccessToken String accessToken) {
        this.adminTokenControllerService.renewAdminAccessToken(response, accessToken, "adminAccessToken", "adminAccessTokenExpiredAt", this.settingService.isAdminAccessTokenHttpOnly());
        return ResponseEntity.noContent();
    }

    @DoPost(value="/admins/me/access-token/fetch")
    public AdminAccessTokenResponse adminsMeAccessTokenFetchPost(@AdminId long adminId, @RequestBody RquiredPasswordRequest request) {
        this.authenticationValidator.validate(adminId, request);
        return this.adminTokenControllerService.getAdminAccessTokenByAdminIdAndType(adminId, AccessTokenType.ACCESS_TOKEN.toString());
    }

    @DoGet(value="/admins/me/access-token/fetch-to-cookie")
    public ResponseEntity adminsMeAccessTokenFetchToCookieGet(HttpServletResponse response, @AdminAccessToken String accessToken) {
        this.adminTokenControllerService.fetchAdminAccessTokenToResponse(response, accessToken, "adminAccessToken", "adminAccessTokenExpiredAt", this.settingService.isAdminAccessTokenHttpOnly());
        return ResponseEntity.noContent();
    }

    @DoGet(value="/admins/me/socket-access-token")
    public AdminAccessTokenResponse adminsMeSocketAccessTokenGet(HttpServletResponse response, @AdminId long adminId) {
        return this.adminTokenControllerService.setAdminAccessTokenToResponse(response, adminId, AccessTokenType.SOCKET_TOKEN.toString(), "adminSocketAccessToken", "adminSocketAccessTokenExpiredAt", Boolean.FALSE);
    }

    @DoDelete(value="/admins/me/access-tokens")
    public ResponseEntity adminsMeAccessTokensDelete(@AdminId long adminId, HttpServletResponse response, @RequestBody RquiredPasswordRequest request) {
        this.authenticationValidator.validate(adminId, request);
        this.adminTokenControllerService.deleteAllAdminAccessTokens(response, adminId);
        return ResponseEntity.noContent();
    }

    @Generated
    public AdminApiAuthenticationController(AdminSettingService settingService, AdminAdminTokenControllerService adminTokenControllerService, AdminAuthenticationValidator authenticationValidator) {
        this.settingService = settingService;
        this.adminTokenControllerService = adminTokenControllerService;
        this.authenticationValidator = authenticationValidator;
    }
}

