/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.AdminInfoResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminMetaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminRoleModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.rx.Reactive;

@EzySingleton
public class AdminAdminDecorator {
    private final AdminAdminMetaService adminMetaService;
    private final AdminAdminRoleService adminRoleService;
    private final AdminMediaService mediaService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public PaginationModel<AdminInfoResponse> decorateToAdminInfoResponsePagination(PaginationModel<AdminModel> pagination) {
        List models = pagination.getItems();
        Set mediaIds = models.stream().map(AdminModel::getAvatarImageId).filter(it -> it > 0L).collect(Collectors.toSet());
        List adminIds = EzyLists.newArrayList((Collection)models, AdminModel::getId);
        return (PaginationModel)Reactive.multiple().register((Object)"mediaById", () -> this.mediaService.getMediaNameMapByIds(mediaIds)).register((Object)"jobTitleByAdminId", () -> this.adminMetaService.getJobTitleMapByAdminIds(adminIds)).blockingGet(map -> {
            Map mediaById = (Map)map.get((Object)"mediaById");
            Map jobTitleByAdminId = (Map)map.get((Object)"jobTitleByAdminId");
            return pagination.map(it -> this.modelToResponseConverter.toResponse((AdminModel)it, (MediaNameModel)mediaById.get(it.getAvatarImageId()), (String)jobTitleByAdminId.get(it.getId())));
        });
    }

    public PaginationModel<AdminRoleMemberResponse> decorateToRoleMemberResponsePagination(PaginationModel<AdminModel> pagination, long roleId) {
        List adminIds = EzyLists.newArrayList((Collection)pagination.getItems(), AdminModel::getId);
        Map<Long, AdminRoleModel> adminRoleMap = this.adminRoleService.getAdminRoleMapByRoleIdAndAdminIds(roleId, adminIds);
        return pagination.map(it -> this.modelToResponseConverter.toAdminRoleMemberResponse((AdminModel)it, (AdminRoleModel)adminRoleMap.get(it.getId())));
    }

    @Generated
    public AdminAdminDecorator(AdminAdminMetaService adminMetaService, AdminAdminRoleService adminRoleService, AdminMediaService mediaService, AdminModelToResponseConverter modelToResponseConverter) {
        this.adminMetaService = adminMetaService;
        this.adminRoleService = adminRoleService;
        this.mediaService = mediaService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

