/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.Cookie;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformKeyManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminMarketProxyValidator;

@Authenticated
@Controller
@EzyFeature(value="devops")
public class AdminMarketProxyController
extends EzyLoggable {
    private final AdminEzyPlatformKeyManager ezyPlatformKeyManager;
    private final AdminMarketUrlManager marketUrlManager;
    private final AdminSettingService settingService;
    private final AdminMarketProxyValidator adminMarketProxyValidator;
    private static final long INITIALIZED_TIME = System.currentTimeMillis();

    @DoGet(value="/market/sso")
    public Redirect marketSsoGet(@RequestParam(value="callbackUri") String callbackUri, @RequestParam(value="buyPluginName") String buyPluginName) throws Exception {
        this.adminMarketProxyValidator.validateSsoCallbackUri(callbackUri);
        String nonce = this.settingService.encryptValue(String.valueOf(INITIALIZED_TIME));
        String encodedNonce = URLEncoder.encode(nonce, StandardCharsets.UTF_8.toString());
        String originUrl = this.settingService.getAdminUrl();
        String encodedOriginUrl = URLEncoder.encode(originUrl, StandardCharsets.UTF_8.toString());
        String encodedCallbackUri = URLEncoder.encode(callbackUri, StandardCharsets.UTF_8.toString());
        String redirectUri = this.marketUrlManager.getPlatformSsoUrl() + "?platformKey=" + this.ezyPlatformKeyManager.getPlatformKey() + "&nonce=" + encodedNonce + "&originUrl=" + encodedOriginUrl + "&callbackUri=" + encodedCallbackUri;
        if (EzyStrings.isNotBlank((String)buyPluginName)) {
            redirectUri = redirectUri + "&buyProjectName=" + buyPluginName;
        }
        return Redirect.to((String)redirectUri);
    }

    @DoGet(value="/market/sso-callback")
    public Redirect marketSsoCallbackGet(@RequestParam(value="platformKey") String platformKey, @RequestParam(value="nonce") String nonce, @RequestParam(value="callbackUri") String callbackUri, @RequestParam(value="buyProjectName") String buyPluginName, @RequestParam(value="marketAccessToken") String marketAccessToken, @RequestParam(value="marketAccessTokenExpiredAt") long marketAccessTokenExpiredAt) {
        this.adminMarketProxyValidator.validateSsoPlatformKey(platformKey);
        this.adminMarketProxyValidator.validateSsoNonce(nonce, INITIALIZED_TIME);
        this.adminMarketProxyValidator.validateSsoCallbackUri(callbackUri);
        Cookie tokenCookie = new Cookie("marketAccessToken", marketAccessToken);
        tokenCookie.setPath("/");
        tokenCookie.setHttpOnly(true);
        Cookie tokenCookieExpiredAt = new Cookie("marketAccessTokenExpiredAt", String.valueOf(marketAccessTokenExpiredAt));
        tokenCookieExpiredAt.setPath("/");
        tokenCookieExpiredAt.setHttpOnly(true);
        String actualCallbackUri = callbackUri;
        if (EzyStrings.isNotBlank((String)buyPluginName) && !actualCallbackUri.contains("name=")) {
            actualCallbackUri = actualCallbackUri.contains("?") ? actualCallbackUri + "&" : actualCallbackUri + "?";
            actualCallbackUri = actualCallbackUri + "name=" + buyPluginName;
        }
        return Redirect.builder().uri(actualCallbackUri).addCookie(tokenCookie).addCookie(tokenCookieExpiredAt).addAttribute("openBy", (Object)"marketSsoCallback").build();
    }

    @Generated
    public AdminMarketProxyController(AdminEzyPlatformKeyManager ezyPlatformKeyManager, AdminMarketUrlManager marketUrlManager, AdminSettingService settingService, AdminMarketProxyValidator adminMarketProxyValidator) {
        this.ezyPlatformKeyManager = ezyPlatformKeyManager;
        this.marketUrlManager = marketUrlManager;
        this.settingService = settingService;
        this.adminMarketProxyValidator = adminMarketProxyValidator;
    }
}

