/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.io.AdminPropertiesFileReader;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.io.PropertiesFileProxy;

@EzySingleton
public class AdminPropertiesFileWriter {
    private final AdminFileSystemManager fileSystemManager;
    private final AdminPropertiesFileReader propertiesFileReader;

    public void writeAdminConfigToFile(Map<?, ?> properties) {
        this.writePropertiesToFile(properties, "admin/settings/config.properties");
    }

    public void writeSocketConfigToFile(Map<?, ?> properties) {
        this.writePropertiesToFile(properties, "socket/settings/config.properties");
    }

    public void setSocketConfigToFile(Map<?, ?> someProperties) {
        Properties properties = this.propertiesFileReader.readSocketConfigProperties();
        properties.putAll(someProperties);
        this.writePropertiesToFile(properties, "socket/settings/config.properties");
    }

    public void writeWebConfigToFile(Map<?, ?> properties) {
        this.writePropertiesToFile(properties, "web/settings/config.properties");
    }

    public void writePropertiesToFile(Map<?, ?> properties, String propertiesFile) {
        PropertiesFileProxy.sortAndWrite(properties, (File)new File(this.fileSystemManager.concatWithEzyHome(propertiesFile)));
    }

    @Generated
    public AdminPropertiesFileWriter(AdminFileSystemManager fileSystemManager, AdminPropertiesFileReader propertiesFileReader) {
        this.fileSystemManager = fileSystemManager;
        this.propertiesFileReader = propertiesFileReader;
    }
}

