/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyArrayUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.youngmonkeys.ezyplatform.manager.SimpleFileSystemManager;

@EzySingleton
public class AdminFileSystemManager
extends SimpleFileSystemManager {
    public static final String FOLDER_BACKUP = "backup";
    public static final String FOLDER_UPLOAD_MODULES = "upload/modules";
    public static final String FOLDER_UPLOAD_PLATFORMS = "upload/platforms";
    public static final String FOLDER_EZYPLATFORM = "ezyplatform";
    public static final String FOLDER_ADMIN_SCRIPTS = "admin/resources/scripts";
    public static final String FILE_PLATFORM_PROPERTIES = "platform.properties";
    public static final String FILE_CONFIG_ADMIN = "admin/settings/config.properties";
    public static final String FILE_CONFIG_SOCKET = "socket/settings/config.properties";
    public static final String FILE_CONFIG_WEB = "web/settings/config.properties";
    public static final String FILE_UPDATE_FILES = "update-files.txt";
    public static final String FILE_RECOVERY = "recovery";
    public static final String FILE_NEW_MODULES = "new-modules";
    public static final Set<String> TOOLS_AND_SCRIPT_PATHS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"update.sh", "update.bat", "tools"}));

    public File getRuntimeFolder() {
        return this.concatWithEzyHome(Paths.get(".runtime", new String[0]));
    }

    public File getAdminScriptsFolder() {
        return this.concatWithEzyHome(Paths.get(FOLDER_ADMIN_SCRIPTS, new String[0]));
    }

    public List<File> getAdminScriptFiles() {
        return this.getScriptFilesInFolder(this.getAdminScriptsFolder());
    }

    public List<File> getNewEzyplatformAdminScriptFiles() {
        return this.getScriptFilesInFolder(this.getNewEzyPlatformAdminScriptsFolder());
    }

    private List<File> getScriptFilesInFolder(File scriptsFolder) {
        Object[] scriptFiles = scriptsFolder.listFiles();
        if (EzyArrayUtil.isEmpty((Object[])scriptFiles)) {
            return Collections.emptyList();
        }
        return Arrays.asList(scriptFiles);
    }

    public File getUploadModulesFolder() {
        return this.concatWithEzyHome(Paths.get(FOLDER_UPLOAD_MODULES, new String[0]));
    }

    public File getUploadPlatformsFolder() {
        return this.concatWithEzyHome(Paths.get(FOLDER_UPLOAD_PLATFORMS, new String[0]));
    }

    public File getNewEzyPlatformFolder() {
        return this.concatWithEzyHome(Paths.get(FOLDER_UPLOAD_PLATFORMS, FOLDER_EZYPLATFORM));
    }

    public File getNewEzyPlatformAdminScriptsFolder() {
        return this.concatWithEzyHome(Paths.get(FOLDER_UPLOAD_PLATFORMS, FOLDER_EZYPLATFORM, FOLDER_ADMIN_SCRIPTS));
    }

    public File getNewEzyPlatformPropertiesFile() {
        return Paths.get(this.getNewEzyPlatformFolder().toString(), "settings", FILE_PLATFORM_PROPERTIES).toFile();
    }

    public File getNewEzyPlatformUpdateFilesFile() {
        return Paths.get(this.getNewEzyPlatformFolder().toString(), FILE_UPDATE_FILES).toFile();
    }

    public File getNewEzyPlatformRecoverFile() {
        return Paths.get(this.getNewEzyPlatformFolder().toString(), FILE_RECOVERY).toFile();
    }

    public File getNewEzyPlatformNewModulesFile() {
        return Paths.get(this.getNewEzyPlatformFolder().toString(), FILE_NEW_MODULES).toFile();
    }

    public File getBackupFolder() {
        return this.concatWithEzyHome(Paths.get(FOLDER_BACKUP, new String[0]));
    }

    public File getUploadProjectFolder(String projectName) {
        return this.getUploadProjectFile(projectName);
    }

    public File getUploadProjectFile(String projectName) {
        return Paths.get(this.getUploadModulesFolder().toString(), projectName).toFile();
    }
}

