/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzyPostInit;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.file.EzyFileReader;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.properties.file.reader.FileReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.data.InstalledProject;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.data.ModuleDependency;
import org.youngmonkeys.ezyplatform.admin.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.admin.io.AdminModuleMetadataInteractor;
import org.youngmonkeys.ezyplatform.admin.io.AdminModulePropertiesReader;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.constant.ModuleAction;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminModuleManager
extends EzyLoggable {
    private final EzyFileReader fileReader;
    private final FileReader propertiesFileReader;
    private final AdminFileSystemManager fileSystemManager;
    private final AdminModulePropertiesReader modulePropertiesReader;
    private final AdminModuleMetadataInteractor moduleMetadataInteractor;
    private final Map<String, String> newVersionByProject = new ConcurrentHashMap<String, String>();
    private final Map<ModuleType, Map<String, Module>> moduleMapByType = new ConcurrentHashMap<ModuleType, Map<String, Module>>();
    private final Map<ModuleType, Map<String, Module>> newModuleMapByType = new ConcurrentHashMap<ModuleType, Map<String, Module>>();
    private final Map<ModuleType, Map<String, ModuleMetadata>> moduleMetadataMapByType = new ConcurrentHashMap<ModuleType, Map<String, ModuleMetadata>>();
    private final Map<String, Set<String>> dependencyNamesByProject = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Map<ModuleType, Set<String>>> dependingModulesByProject = new ConcurrentHashMap<String, Map<ModuleType, Set<String>>>();
    private static final String FOLDER_SCRIPTS = "resources/scripts";
    public static final Map<TargetType, ModuleType[]> MODULE_TYPES_BY_TARGET = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)TargetType.ADMIN, (Object)new ModuleType[]{ModuleType.ADMIN_PLUGIN}).put((Object)TargetType.WEB, (Object)new ModuleType[]{ModuleType.WEB_PLUGIN, ModuleType.THEME}).put((Object)TargetType.SOCKET, (Object)new ModuleType[]{ModuleType.SOCKET_PLUGIN, ModuleType.SOCKET_APP}).toMap());

    @EzyPostInit
    public void load() {
        this.loadAllModules();
        this.loadProjectNewVersions();
        this.loadAllNewModules();
    }

    private void loadAllModules() {
        this.moduleMetadataMapByType.putAll(this.readModuleMetadataMap());
        for (ModuleType moduleType : ModuleType.values()) {
            this.loadModule(moduleType);
        }
    }

    public void loadProjectNewVersions() {
        File file = this.fileSystemManager.getNewEzyPlatformNewModulesFile();
        if (file.exists()) {
            this.newVersionByProject.putAll(this.propertiesFileReader.read(file));
        } else {
            this.newVersionByProject.clear();
        }
    }

    private void loadAllNewModules() {
        for (String projectName : this.newVersionByProject.keySet()) {
            this.loadNewProjectModules(projectName);
        }
    }

    public void actModule(ModuleType moduleType, String moduleName, ModuleAction action) {
        Map<String, Module> moduleMap = this.getModuleMap(moduleType);
        Module module = moduleMap.get(moduleName);
        if (module != null) {
            if (action == ModuleAction.DELETE) {
                moduleMap.remove(moduleName);
            } else {
                module.setActive(action == ModuleAction.ACTIVATE);
            }
            this.updateDependingModules(module, action);
        }
        Map moduleMetadataMap = this.moduleMetadataMapByType.computeIfAbsent(moduleType, k -> new ConcurrentHashMap());
        if (action == ModuleAction.DELETE) {
            int moduleCount = this.getModuleCountOfProject(moduleName);
            if (moduleCount == 0) {
                moduleMetadataMap.remove(moduleName);
                this.dependencyNamesByProject.remove(moduleName);
                this.newVersionByProject.remove(moduleName);
            }
        } else {
            ModuleMetadata moduleMetadata = (ModuleMetadata)moduleMetadataMap.get(moduleName);
            if (moduleMetadata == null) {
                moduleMetadata = new ModuleMetadata();
                moduleMetadata.setName(moduleName);
                moduleMetadataMap.put(moduleName, moduleMetadata);
            }
            moduleMetadata.setActive(action == ModuleAction.ACTIVATE);
        }
        this.moduleMetadataInteractor.write(this.fileSystemManager.getRuntimeFolder(), moduleType, moduleMetadataMap);
        if (action == ModuleAction.DELETE) {
            FolderProxy.deleteFolder((File)this.getModuleFolderPath(moduleType, moduleName));
        }
    }

    public Module activateDefaultThemeIfNeed() {
        if (this.hasActivatedTheme()) {
            return null;
        }
        Module defaultTheme = this.getModule(ModuleType.THEME, "welcome");
        if (defaultTheme == null) {
            return null;
        }
        this.actModule(ModuleType.THEME, "welcome", ModuleAction.ACTIVATE);
        return defaultTheme;
    }

    private void updateDependingModules(Module module, ModuleAction action) {
        if (action == ModuleAction.ACTIVATE) {
            this.addToDependingModules(module);
        } else {
            this.removeFromDependingModules(module, action);
        }
    }

    public String getTargetNameByModuleType(ModuleType moduleType) {
        return moduleType.getParentFolder();
    }

    public List<String> getTargetNames(Collection<ModuleType> moduleTypes) {
        return moduleTypes.stream().map(this::getTargetNameByModuleType).distinct().collect(Collectors.toList());
    }

    public ModuleType[] getModuleTypesByTarget(TargetType targetType) {
        return MODULE_TYPES_BY_TARGET.get(targetType);
    }

    public Set<String> getContainerFoldersByTarget(TargetType targetType) {
        return EzySets.newHashSet((Object[])this.getModuleTypesByTarget(targetType), ModuleType::getContainerFolder);
    }

    public Set<String> filterProjectsContainsSqlScripts(List<Module> modules) {
        return modules.stream().map(Module::getName).distinct().filter(this::isProjectContainsSqlScripts).collect(Collectors.toSet());
    }

    public boolean isProjectContainsSqlScripts(String projectName) {
        for (Module module : this.getModulesOfProject(projectName)) {
            List<File> files = this.listSqlScriptFiles(module.getType(), module.getName());
            if (files.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Map<Module, List<File>> listSqlScripFilesOfProject(String projectName) {
        HashMap<Module, List<File>> scriptFiles = new HashMap<Module, List<File>>();
        for (Module module : this.getModulesOfProject(projectName)) {
            List<File> files = this.listSqlScriptFiles(module.getType(), module.getName());
            if (files.isEmpty()) continue;
            scriptFiles.put(module, files);
        }
        return scriptFiles;
    }

    public Module getFirstModuleOfProject(String projectName) {
        for (ModuleType moduleType : ModuleType.values()) {
            Module module = this.getModule(moduleType, projectName);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public List<Module> getModulesOfProject(String projectName) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (ModuleType moduleType : ModuleType.values()) {
            Module module = this.getModule(moduleType, projectName);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    public List<Module> getNewModulesOfProject(String projectName) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (ModuleType moduleType : ModuleType.values()) {
            Module module = this.getNewModule(moduleType, projectName);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    public int getModuleCountOfProject(String projectName) {
        int count = 0;
        for (ModuleType moduleType : ModuleType.values()) {
            Module module = this.getModule(moduleType, projectName);
            if (module == null) continue;
            ++count;
        }
        return count;
    }

    public List<ModuleType> getModuleTypesOfProject(String projectName) {
        return EzyLists.newArrayList(this.getModulesOfProject(projectName), Module::getType);
    }

    public List<ModuleType> getAllModuleTypesOfProject(String projectName) {
        return Stream.of(this.getModulesOfProject(projectName), this.getNewModulesOfProject(projectName)).flatMap(Collection::stream).map(Module::getType).distinct().collect(Collectors.toList());
    }

    public Set<ModuleType> getModuleTypesOfProjectDependencies(String projectName) {
        Set<String> dependingModuleNames = this.getDependencyNamesOfProject(projectName);
        HashSet<ModuleType> answer = new HashSet<ModuleType>();
        for (String moduleName : dependingModuleNames) {
            answer.addAll(this.getAllModuleTypesOfProject(moduleName));
        }
        return answer;
    }

    public Set<String> getActivatedProjectNames() {
        HashSet<String> answer = new HashSet<String>();
        for (ModuleType moduleType : this.moduleMetadataMapByType.keySet()) {
            Map<String, ModuleMetadata> moduleMetadataMap = this.moduleMetadataMapByType.get(moduleType);
            for (String projectName : moduleMetadataMap.keySet()) {
                ModuleMetadata moduleMetadata = moduleMetadataMap.get(projectName);
                if (!moduleMetadata.isActive()) continue;
                answer.add(projectName);
            }
        }
        return answer;
    }

    public List<InstalledProject> getAllProjects() {
        HashMap<String, String> projectVersions = new HashMap<String, String>();
        for (ModuleType moduleType : this.moduleMapByType.keySet()) {
            Map<String, Module> moduleMap = this.moduleMapByType.get(moduleType);
            for (String projectName : moduleMap.keySet()) {
                Module module = moduleMap.get(projectName);
                projectVersions.put(projectName, module.getVersion());
            }
        }
        return EzyLists.newArrayList(projectVersions, InstalledProject::new);
    }

    public List<Module> getAllModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (ModuleType moduleType : ModuleType.values()) {
            modules.addAll(this.getModules(moduleType));
        }
        return modules;
    }

    public int getModuleCount(ModuleType moduleType) {
        return this.getModuleMap(moduleType).size();
    }

    public List<Module> getActivatedThemes() {
        ArrayList<Module> answer = new ArrayList<Module>();
        for (Module theme : this.getModules(ModuleType.THEME)) {
            if (!theme.isActive()) continue;
            answer.add(theme);
        }
        return answer;
    }

    public Module getModule(ModuleType moduleType, String moduleName) {
        return this.getModuleMap(moduleType).get(moduleName);
    }

    public Module getNewModule(ModuleType moduleType, String moduleName) {
        return (Module)this.newModuleMapByType.getOrDefault(moduleType, Collections.emptyMap()).get(moduleName);
    }

    public List<Module> getModules(ModuleType moduleType) {
        return new ArrayList<Module>(this.getModuleMap(moduleType).values());
    }

    public Set<String> getDependingModuleNames(ModuleType moduleType, String projectName) {
        return this.dependingModulesByProject.getOrDefault(projectName, Collections.emptyMap()).getOrDefault(moduleType, Collections.emptySet());
    }

    public Set<String> getDependencyNamesOfProject(String projectName) {
        HashSet<String> moduleNames = new HashSet<String>();
        LinkedList<String> queue = new LinkedList<String>();
        queue.add(projectName);
        while (!queue.isEmpty()) {
            String moduleName = (String)queue.poll();
            Set dependencyModuleNames = this.dependencyNamesByProject.getOrDefault(moduleName, Collections.emptySet());
            for (String dependencyModuleName : dependencyModuleNames) {
                if (projectName.equals(dependencyModuleName) || moduleNames.contains(dependencyModuleName)) continue;
                moduleNames.add(dependencyModuleName);
                queue.add(dependencyModuleName);
            }
        }
        return moduleNames;
    }

    public Set<ModuleDependency> getDependenciesOfModule(ModuleType moduleType, String moduleName) {
        LinkedList<String> queue = new LinkedList<String>();
        queue.offer(moduleName);
        HashSet<ModuleDependency> dependencies = new HashSet<ModuleDependency>();
        while (!queue.isEmpty()) {
            Module newModule;
            ModuleType actualModuleType;
            Module module;
            String moduleNameItem = (String)queue.poll();
            HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>();
            if (moduleNameItem.equals(moduleName)) {
                Module newModule2;
                Module module2 = this.getModule(moduleType, moduleNameItem);
                if (module2 != null) {
                    moduleDependencies.addAll(module2.getDependencies());
                }
                if ((newModule2 = this.getNewModule(moduleType, moduleNameItem)) != null) {
                    moduleDependencies.addAll(newModule2.getDependencies());
                }
            }
            if ((module = this.getModule(actualModuleType = moduleType != ModuleType.THEME ? moduleType : ModuleType.WEB_PLUGIN, moduleNameItem)) != null) {
                moduleDependencies.addAll(module.getDependencies());
            }
            if ((newModule = this.getNewModule(actualModuleType, moduleNameItem)) != null) {
                moduleDependencies.addAll(newModule.getDependencies());
            }
            for (ModuleDependency dependency : moduleDependencies) {
                String dependencyModuleName = dependency.getProjectName();
                if (moduleName.equals(dependencyModuleName) || dependencies.contains(dependency)) continue;
                dependencies.add(dependency);
                queue.add(dependencyModuleName);
            }
        }
        return dependencies;
    }

    public boolean hasActivatedTheme() {
        for (Module theme : this.getModules(ModuleType.THEME)) {
            if (!theme.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean containsProject(String projectName) {
        for (ModuleType moduleType : ModuleType.values()) {
            if (!this.containsModule(moduleType, projectName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProject(String projectName, String version) {
        for (ModuleType moduleType : ModuleType.values()) {
            Module module = this.getModule(moduleType, projectName);
            if (module == null || !module.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    public String getProjectVersion(String projectName) {
        for (ModuleType moduleType : ModuleType.values()) {
            Module module = this.getModule(moduleType, projectName);
            if (module == null) continue;
            return module.getVersion();
        }
        return null;
    }

    public String getProjectNewVersion(String projectName) {
        return this.newVersionByProject.get(projectName);
    }

    public void setNewProjectVersion(String projectName, String newVersion) {
        this.newVersionByProject.put(projectName, newVersion);
    }

    public Set<String> getActivatedProjectNamesHasNewVersion() {
        Set<String> activateProjectNames = this.getActivatedProjectNames();
        return EzySets.filter(this.newVersionByProject.keySet(), activateProjectNames::contains);
    }

    public Map<String, String> getProjectNewVersions() {
        return new HashMap<String, String>(this.newVersionByProject);
    }

    public boolean containsModule(ModuleType moduleType, String moduleName) {
        return this.getModule(moduleType, moduleName) != null;
    }

    public Module findAdminModuleByPackage(String packageName) {
        List<Module> modules = this.getModules(ModuleType.ADMIN_PLUGIN);
        for (Module module : modules) {
            if (!EzyStrings.isNotBlank((String)module.getPackageName()) || !packageName.startsWith(module.getPackageName())) continue;
            return module;
        }
        return null;
    }

    public List<File> listSqlScriptFiles(ModuleType moduleType, String moduleName) {
        File scriptsFolder = Paths.get(this.getContainerFolderPath(moduleType).toString(), moduleName, FOLDER_SCRIPTS).toFile();
        File[] files = scriptsFolder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(it -> it.getName().endsWith("sql")).collect(Collectors.toList());
    }

    public String getModuleFileContent(ModuleType moduleType, String moduleName, String filePath) {
        try {
            if (EzyStrings.isNoContent((String)filePath)) {
                return "";
            }
            File file = this.getModuleFile(moduleType, moduleName, filePath);
            if (!file.exists()) {
                return "";
            }
            byte[] bytes = this.fileReader.readBytes(file);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.logger.debug("module (type: {}, name: {}), read file: {} error", new Object[]{moduleType, moduleName, filePath});
            return "";
        }
    }

    public SortedMap<String, String> readMenuProperties(ModuleType moduleType, String moduleName, String menuFilePath) {
        try {
            Path path;
            if (!EzyStrings.isNoContent((String)menuFilePath) && Files.exists(path = this.getModuleFilePath(moduleType, moduleName, menuFilePath), new LinkOption[0])) {
                return this.readMenuProperties(path);
            }
        }
        catch (Exception e) {
            this.logger.info("read file: {} in module (type: {}, name: {}) error", new Object[]{menuFilePath, moduleType, moduleName});
        }
        return Collections.emptySortedMap();
    }

    private SortedMap<String, String> readMenuProperties(Path path) throws IOException {
        try (Stream<String> stream = Files.lines(path);){
            List menuDataList = stream.map(InternalMenuData::fromLine).filter(Objects::nonNull).collect(Collectors.toList());
            HashMap<String, Integer> menuIndexByName = new HashMap<String, Integer>();
            for (int i = 0; i < menuDataList.size(); ++i) {
                menuIndexByName.put(((InternalMenuData)menuDataList.get(i)).name, i);
            }
            TreeMap<String, String> map = new TreeMap<String, String>(Comparator.comparingInt(menuIndexByName::get));
            for (InternalMenuData menuData : menuDataList) {
                map.put(menuData.name.trim(), menuData.value.trim());
            }
            TreeMap<String, String> treeMap = map;
            return treeMap;
        }
    }

    private void loadModule(ModuleType moduleType) {
        Map modules = this.moduleMapByType.computeIfAbsent(moduleType, k -> new ConcurrentHashMap());
        File containerFolder = this.getContainerFolderPath(moduleType);
        List moduleFolders = FolderProxy.listFolders((File)containerFolder);
        for (File moduleFolder : moduleFolders) {
            String projectName = moduleFolder.getName();
            modules.computeIfAbsent(projectName, k -> this.readModuleProperties(moduleType, moduleFolder));
        }
    }

    public void loadProjectModules(String projectName) {
        for (ModuleType moduleType : ModuleType.values()) {
            File moduleFolder = this.getModuleFolderPath(moduleType, projectName);
            if (!moduleFolder.exists()) continue;
            Map modules = this.moduleMapByType.computeIfAbsent(moduleType, k -> new ConcurrentHashMap());
            modules.computeIfAbsent(projectName, k -> this.readModuleProperties(moduleType, moduleFolder));
        }
    }

    private Module readModuleProperties(ModuleType moduleType, File moduleFolder) {
        Module moduleProperties = this.modulePropertiesReader.read(moduleType, moduleFolder);
        ModuleMetadata moduleMetadata = this.moduleMetadataMapByType.computeIfAbsent(moduleType, k -> new ConcurrentHashMap()).computeIfAbsent(moduleFolder.getName(), k -> new ModuleMetadata((String)k, false));
        moduleProperties.setActive(moduleMetadata.isActive());
        this.addProjectDependencyNames(moduleProperties);
        if (moduleMetadata.isActive()) {
            this.addToDependingModules(moduleProperties);
        }
        return moduleProperties;
    }

    public void loadNewProjectModules(String projectName) {
        for (ModuleType moduleType : ModuleType.values()) {
            File moduleFolder = this.getNewModuleFolderPath(moduleType, projectName);
            if (!moduleFolder.exists()) continue;
            Module newModule = this.modulePropertiesReader.read(moduleType, moduleFolder);
            this.newModuleMapByType.computeIfAbsent(moduleType, k -> new ConcurrentHashMap()).put(projectName, newModule);
            this.addProjectDependencyNames(newModule);
        }
    }

    private void addProjectDependencyNames(Module module) {
        for (ModuleDependency dependency : module.getDependencies()) {
            this.dependencyNamesByProject.computeIfAbsent(module.getName(), k -> ConcurrentHashMap.newKeySet()).add(dependency.getProjectName());
        }
    }

    private void addToDependingModules(Module module) {
        for (ModuleDependency dependency : module.getDependencies()) {
            this.dependingModulesByProject.computeIfAbsent(dependency.getProjectName(), it -> new ConcurrentHashMap()).computeIfAbsent(module.getType(), it -> ConcurrentHashMap.newKeySet()).add(module.getName());
        }
    }

    private void removeFromDependingModules(Module module, ModuleAction action) {
        String moduleName = module.getName();
        ModuleType moduleType = module.getType();
        for (ModuleDependency dependency : module.getDependencies()) {
            this.dependingModulesByProject.getOrDefault(dependency.getProjectName(), Collections.emptyMap()).getOrDefault(moduleType, Collections.emptySet()).remove(moduleName);
        }
        if (action == ModuleAction.DELETE) {
            Map dependingModules = this.dependingModulesByProject.getOrDefault(moduleName, Collections.emptyMap());
            dependingModules.remove(moduleType);
            if (dependingModules.isEmpty()) {
                this.dependingModulesByProject.remove(moduleName);
            }
        }
    }

    private Map<ModuleType, Map<String, ModuleMetadata>> readModuleMetadataMap() {
        return this.moduleMetadataInteractor.read(this.fileSystemManager.getRuntimeFolder());
    }

    private Map<String, Module> getModuleMap(ModuleType moduleType) {
        Map<String, Module> answer = this.moduleMapByType.get(moduleType);
        return answer != null ? answer : Collections.emptyMap();
    }

    private File getModuleFile(ModuleType moduleType, String moduleName, String filePath) {
        return this.getModuleFilePath(moduleType, moduleName, filePath).toFile();
    }

    private Path getModuleFilePath(ModuleType moduleType, String moduleName, String filePath) {
        return Paths.get(this.getModuleFolderPath(moduleType, moduleName).toString(), filePath);
    }

    private File getModuleFolderPath(ModuleType moduleType, String moduleName) {
        return Paths.get(this.getContainerFolderPath(moduleType).toString(), moduleName).toFile();
    }

    private File getNewModuleFolderPath(ModuleType moduleType, String moduleName) {
        return Paths.get(this.getNewContainerFolderPath(moduleType).toString(), moduleName).toFile();
    }

    private File getContainerFolderPath(ModuleType moduleType) {
        return this.fileSystemManager.concatWithEzyHome(moduleType.getTargetFolderPath());
    }

    private File getNewContainerFolderPath(ModuleType moduleType) {
        return Paths.get(this.fileSystemManager.getNewEzyPlatformFolder().toString(), moduleType.getTargetFolderPath().toString()).toFile();
    }

    @Generated
    public AdminModuleManager(EzyFileReader fileReader, FileReader propertiesFileReader, AdminFileSystemManager fileSystemManager, AdminModulePropertiesReader modulePropertiesReader, AdminModuleMetadataInteractor moduleMetadataInteractor) {
        this.fileReader = fileReader;
        this.propertiesFileReader = propertiesFileReader;
        this.fileSystemManager = fileSystemManager;
        this.modulePropertiesReader = modulePropertiesReader;
        this.moduleMetadataInteractor = moduleMetadataInteractor;
    }

    private static class InternalMenuData {
        private String name;
        private String value;

        public static InternalMenuData fromLine(String line) {
            String str = line.trim();
            if (EzyStrings.isBlank((String)str) || str.startsWith("#") || !str.contains("=") || str.startsWith("=")) {
                return null;
            }
            int indexOf = str.indexOf(61);
            if (indexOf == str.length() - 1) {
                return null;
            }
            return new InternalMenuData(str.substring(0, indexOf), str.substring(indexOf + 1));
        }

        @Generated
        public InternalMenuData(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

