/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzySHA256;
import com.tvd12.ezyfox.util.Next;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminResultToModelConverter;
import org.youngmonkeys.ezyplatform.admin.exception.AdminNotFoundException;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateAdminModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminAdminAccessTokenRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminAdminRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminAccessTokenService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminMetaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;
import org.youngmonkeys.ezyplatform.entity.Admin;
import org.youngmonkeys.ezyplatform.entity.AdminAccessToken;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.exception.ForbiddenActionException;
import org.youngmonkeys.ezyplatform.exception.IncorrectPasswordException;
import org.youngmonkeys.ezyplatform.exception.PermissionDeniedException;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.repo.AdminAccessTokenRepository;
import org.youngmonkeys.ezyplatform.repo.AdminRepository;
import org.youngmonkeys.ezyplatform.service.AdminAccessTokenService;
import org.youngmonkeys.ezyplatform.service.DefaultAdminService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

@Service
public class AdminAdminService
extends DefaultAdminService {
    private final ClockProxy clock;
    private final AdminAdminRoleService roleService;
    private final AdminSettingService settingService;
    private final AdminAdminMetaService adminMetaService;
    private final AdminAdminAccessTokenService accessTokenService;
    private final PasswordManager passwordManager;
    private final AdminAdminRepository adminRepository;
    private final AdminAdminAccessTokenRepository accessTokenRepository;
    private final AdminEntityToModelConverter entityToModelConverter;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private final AdminResultToModelConverter resultToModelConverter;

    public AdminAdminService(ClockProxy clock, AdminAdminRoleService roleService, AdminSettingService settingService, AdminAdminMetaService adminMetaService, AdminAdminAccessTokenService accessTokenService, PasswordManager passwordManager, AdminAdminRepository adminRepository, AdminAdminAccessTokenRepository accessTokenRepository, AdminEntityToModelConverter entityToModelConverter, AdminModelToEntityConverter modelToEntityConverter, AdminResultToModelConverter resultToModelConverter) {
        super(clock, (AdminAccessTokenService)accessTokenService, (AdminRepository)adminRepository, (AdminAccessTokenRepository)accessTokenRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultResultToModelConverter)resultToModelConverter);
        this.clock = clock;
        this.roleService = roleService;
        this.settingService = settingService;
        this.adminMetaService = adminMetaService;
        this.accessTokenService = accessTokenService;
        this.passwordManager = passwordManager;
        this.adminRepository = adminRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
        this.resultToModelConverter = resultToModelConverter;
    }

    public List<AdminModel> getAdmins() {
        return this.adminRepository.findAll().stream().map(arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0)).collect(Collectors.toList());
    }

    public List<AdminModel> getAdminsByRoleIds(Collection<Long> roleIds) {
        return this.adminRepository.findAdminsByRoleIds(roleIds).stream().map(arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0)).collect(Collectors.toList());
    }

    public List<AdminModel> getAdminsByRoleNames(Collection<String> roleNames) {
        return this.adminRepository.findAdminsByRoleNames(roleNames).stream().map(arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0)).collect(Collectors.toList());
    }

    public Optional<AdminModel> getFirstActiveSuperAdmin() {
        return this.getActiveSuperAdmins(1).stream().findFirst();
    }

    public List<AdminModel> getActiveSuperAdmins(int limit) {
        return this.adminRepository.findActiveSuperAdmins(Next.limit((long)limit)).stream().map(arg_0 -> ((AdminEntityToModelConverter)this.entityToModelConverter).toModel(arg_0)).collect(Collectors.toList());
    }

    public AdminAccessTokenModel getAccessTokenByAdminIdAndType(long adminId, String tokenType) {
        return this.entityToModelConverter.toModel(this.accessTokenRepository.findByAdminIdAndTokenType(adminId, tokenType));
    }

    public AdminAccessTokenModel getOrCreateAccessTokenByAdminId(long adminId) {
        return this.getOrCreateAccessTokenByAdminId(adminId, AccessTokenType.ACCESS_TOKEN.toString());
    }

    public AdminAccessTokenModel getOrCreateAccessTokenByAdminId(long adminId, String tokenType) {
        String accessTokenString;
        long extractedAdminId;
        AdminAccessToken accessToken = this.accessTokenRepository.findByAdminIdAndTokenType(adminId, tokenType);
        if (accessToken != null && (extractedAdminId = this.accessTokenService.extractAdminId(accessTokenString = accessToken.getId())) != adminId) {
            this.accessTokenRepository.delete(accessTokenString);
            accessToken = null;
        }
        if (accessToken == null) {
            accessToken = this.newAdminAccessToken(adminId, tokenType, this.getNewAdminAccessTokenStatus(adminId));
            this.accessTokenRepository.save(accessToken);
        } else {
            LocalDateTime now;
            boolean needToSaveAccessToken = false;
            String accessTokenStatusOld = accessToken.getStatus();
            if (!AccessTokenStatus.ACTIVATED_2FA.equalsValue(accessTokenStatusOld)) {
                String accessTokenStatusNew = this.getNewAdminAccessTokenStatus(adminId);
                if (AccessTokenStatus.WAITING_2FA.equalsValue(accessTokenStatusNew)) {
                    accessToken = this.newAdminAccessToken(adminId, tokenType, accessTokenStatusNew);
                    needToSaveAccessToken = true;
                } else if (!Objects.equals(accessTokenStatusNew, accessTokenStatusOld)) {
                    accessToken.setStatus(accessTokenStatusNew);
                    needToSaveAccessToken = true;
                }
            }
            if ((now = this.clock.nowDateTime()).isAfter(accessToken.getExpiredAt())) {
                long extendDays = this.settingService.getAdminTokenExpiredTimeInDay();
                accessToken.setExpiredAt(now.plusDays(extendDays));
                needToSaveAccessToken = true;
            }
            if (needToSaveAccessToken) {
                this.accessTokenRepository.save(accessToken);
            }
        }
        return this.entityToModelConverter.toModel(accessToken);
    }

    public AdminAccessTokenModel renewAccessToken(String accessTokenValue) {
        AdminAccessToken accessToken = (AdminAccessToken)this.accessTokenRepository.findById(accessTokenValue);
        if (accessToken == null) {
            throw new ResourceNotFoundException("accessToken");
        }
        LocalDateTime now = this.clock.nowDateTime();
        long extendDays = this.settingService.getAdminTokenExpiredTimeInDay();
        accessToken.setExpiredAt(now.plusDays(extendDays));
        accessToken.setRenewalCount(accessToken.getRenewalCount() + 1L);
        this.accessTokenRepository.save(accessToken);
        return this.entityToModelConverter.toModel(accessToken);
    }

    private String getNewAdminAccessTokenStatus(long adminId) {
        return this.isEnable2FaByAdminId(adminId) ? AccessTokenStatus.WAITING_2FA.toString() : AccessTokenStatus.ACTIVATED.toString();
    }

    public boolean isEnable2FaByAdminId(long adminId) {
        String value = this.adminMetaService.getMetaValueByAdminIdAndMetaKey(adminId, "enable2FA");
        return "true".equals(value);
    }

    public boolean containsAdminById(long adminId) {
        return this.adminRepository.containsById(adminId);
    }

    public boolean containsAdminByUsername(String username) {
        return this.adminRepository.containsByField("username", username);
    }

    public List<AdminNameModel> simpleSearch(String keyword, int limit) {
        return EzyLists.newArrayList(this.adminRepository.findAdminNamesByKeyword(keyword, Next.limit((long)limit)), arg_0 -> ((AdminResultToModelConverter)this.resultToModelConverter).toAdminNameModel(arg_0));
    }

    public List<AdminNameModel> simpleSearchWithRoleIds(Collection<Long> roleIds, String keyword, int limit) {
        return EzyLists.newArrayList(this.adminRepository.findAdminNamesByKeywordAndRoleIds(roleIds, keyword, Next.limit((long)limit)), arg_0 -> ((AdminResultToModelConverter)this.resultToModelConverter).toAdminNameModel(arg_0));
    }

    public List<AdminNameModel> simpleSearchWithRoleNames(Collection<String> roleNames, String keyword, int limit) {
        return EzyLists.newArrayList(this.adminRepository.findAdminNamesByKeywordAndRoleNames(roleNames, keyword, Next.limit((long)limit)), arg_0 -> ((AdminResultToModelConverter)this.resultToModelConverter).toAdminNameModel(arg_0));
    }

    public long countAllAdmins() {
        return this.adminRepository.count();
    }

    public AdminModel addAdmin(AddAdminModel model) {
        Admin entity = this.modelToEntityConverter.toEntity(model);
        this.doSaveAdminEntityAndRoles(entity, model.getRoleIds());
        return this.entityToModelConverter.toModel(entity);
    }

    private void doSaveAdminEntityAndRoles(Admin entity, Collection<Long> roleIds) {
        this.adminRepository.save(entity);
        this.roleService.replaceAdminRoles(entity.getId(), roleIds);
    }

    public AdminAccessTokenModel addAdminAndGetAccessToken(AddAdminModel adminModel) {
        AdminModel admin = this.addAdmin(adminModel);
        AdminAccessToken accessToken = this.newAdminAccessToken(admin.getId(), AccessTokenType.ACCESS_TOKEN.toString(), AccessTokenStatus.ACTIVATED.toString());
        this.accessTokenRepository.save(accessToken);
        return this.entityToModelConverter.toModel(accessToken);
    }

    public void updateAdmin(long adminId, UpdateAdminModel model) {
        Admin entity = this.getAdminEntityByIdOrThrow(adminId);
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.adminRepository.save(entity);
    }

    public void updateAdmin(String username, UpdateAdminModel model) {
        Admin entity = this.getAdminEntityByUsernameOrThrow(username);
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.adminRepository.save(entity);
    }

    public void updateAvatar(long adminId, long avatarId) {
        Admin entity = this.getAdminEntityByIdOrThrow(adminId);
        entity.setAvatarImageId(avatarId);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
    }

    public void updateCoverImage(long adminId, long coverImageId) {
        Admin entity = this.getAdminEntityByIdOrThrow(adminId);
        entity.setCoverImageId(coverImageId);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
    }

    public void updatePassword(long adminId, String oldPassword, String newPassword) {
        this.updatePassword(this.getAdminEntityByIdOrThrow(adminId), oldPassword, newPassword, () -> IncorrectPasswordException.ofAdminId((long)adminId));
    }

    public void updatePassword(String username, String oldPassword, String newPassword) {
        this.updatePassword(this.getAdminEntityByUsernameOrThrow(username), oldPassword, newPassword, () -> IncorrectPasswordException.ofUserName((String)username));
    }

    public void updatePassword(String username, String newPassword) {
        Admin entity = this.getAdminEntityByUsernameOrThrow(username);
        entity.setPassword(this.passwordManager.hashPassword(newPassword));
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
    }

    private void updatePassword(Admin entity, String oldPassword, String newPassword, Supplier<IncorrectPasswordException> exceptionSupplier) {
        if (!this.passwordManager.isMatchingPassword(oldPassword, entity.getPassword())) {
            throw exceptionSupplier.get();
        }
        entity.setPassword(this.passwordManager.hashPassword(newPassword));
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
    }

    public void setNewPassword(long adminId, String newPassword) {
        Admin entity = this.getAdminEntityByIdOrThrow(adminId);
        entity.setPassword(this.passwordManager.hashPassword(newPassword));
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
        this.adminMetaService.saveAdminMetaUniqueKey(adminId, "resetPasswordToken", "");
    }

    public void archiveAdmin(String username, boolean deleteBySuperAdmin) {
        this.updateInactivateAdminStatus(AdminStatus.ARCHIVED.toString(), username, deleteBySuperAdmin);
    }

    public void blockAdmin(String username, boolean deleteBySuperAdmin) {
        this.updateInactivateAdminStatus(AdminStatus.BLOCKED.toString(), username, deleteBySuperAdmin);
    }

    public void deleteAdmin(String username, boolean deleteBySuperAdmin) {
        this.updateInactivateAdminStatus(AdminStatus.DELETED.toString(), username, deleteBySuperAdmin);
    }

    public void updateInactivateAdminStatus(String status, String username, boolean deleteBySuperAdmin) {
        Admin entity = this.getAdminEntityByUsernameOrThrow(username);
        if (this.roleService.isAdminHavingSuperRole(entity.getId())) {
            if (!deleteBySuperAdmin) {
                throw new PermissionDeniedException("not super admin delete super admin");
            }
            long superAdminCount = this.roleService.countActiveSuperAdmins();
            if (superAdminCount <= 1L) {
                throw new ForbiddenActionException("archiveFinalSuperAdmin");
            }
        }
        this.removeAdminAccessToken(entity.getId());
        entity.setStatus(status);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
    }

    public void activateAdmin(String username) {
        Admin entity = this.getAdminEntityByUsernameOrThrow(username);
        entity.setStatus(AdminStatus.ACTIVATED.toString());
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.adminRepository.save(entity);
    }

    public void removeAdminAccessToken(long adminId) {
        this.accessTokenRepository.deleteByAdminId(adminId);
    }

    public void createNewResetPasswordToken(long adminId, String token, long tokenExpiredAt) {
        String resetPasswordToken = this.makeResetPasswordToken(token, tokenExpiredAt);
        this.adminMetaService.saveAdminMetaUniqueKey(adminId, "resetPasswordToken", resetPasswordToken);
    }

    public void verifyResetPasswordToken(long adminId, String token, long tokenExpiredAt) {
        String storedToken;
        String resetPasswordToken = this.makeResetPasswordToken(token, tokenExpiredAt);
        if (!resetPasswordToken.equals(storedToken = this.adminMetaService.getMetaValueByAdminIdAndMetaKey(adminId, "resetPasswordToken"))) {
            throw new ResourceNotFoundException("token");
        }
    }

    private String makeResetPasswordToken(String token, long tokenExpiredAt) {
        return EzySHA256.cryptUtfToLowercase((String)(token + tokenExpiredAt));
    }

    private Admin getAdminEntityByIdOrThrow(long adminId) {
        Admin entity = (Admin)this.adminRepository.findById(adminId);
        if (entity == null) {
            throw new AdminNotFoundException(adminId);
        }
        return entity;
    }

    private Admin getAdminEntityByUsername(String username) {
        return (Admin)this.adminRepository.findByField("username", username);
    }

    private Admin getAdminEntityByUsernameOrThrow(String username) {
        Admin entity = this.getAdminEntityByUsername(username);
        if (entity == null) {
            throw new AdminNotFoundException(username);
        }
        return entity;
    }

    private AdminAccessToken newAdminAccessToken(long adminId, String tokenType, String status) {
        String token = this.accessTokenService.generateAccessToken(adminId);
        long tokenExpiredTimeInDay = this.settingService.getAdminTokenExpiredTimeInDay();
        return this.modelToEntityConverter.toAdminAccessTokenEntity(adminId, token, tokenType, tokenExpiredTimeInDay, status);
    }

    public void setAllowAccessAllMedia(long adminId, boolean allow) {
        this.adminMetaService.saveAdminMetaUniqueKey(adminId, "allowAccessAllMedia", allow);
    }

    public boolean isAllowAccessAllMedia(long adminId) {
        String value = this.adminMetaService.getLatestMetaValueByAdminIdAndMetaKey(adminId, "allowAccessAllMedia");
        try {
            return EzyStrings.isNotBlank((String)value) && Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAllowAccessAllMedia(long adminId, AdminRolesProxy adminRoles) {
        return adminRoles.isSuperAdmin() || this.isAllowAccessAllMedia(adminId);
    }
}

