/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminResultToModelConverter;
import org.youngmonkeys.ezyplatform.admin.model.AddUserModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateUserModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminUserAccessTokenRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminUserRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminDataRecordCountService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserAccessTokenService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserKeywordService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserMetaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.entity.UserStatus;
import org.youngmonkeys.ezyplatform.exception.IncorrectPasswordException;
import org.youngmonkeys.ezyplatform.exception.UserNotFoundException;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.repo.UserAccessTokenRepository;
import org.youngmonkeys.ezyplatform.repo.UserRepository;
import org.youngmonkeys.ezyplatform.service.DefaultUserService;
import org.youngmonkeys.ezyplatform.service.UserAccessTokenService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.Sha256Uuids;

@Service
public class AdminUserService
extends DefaultUserService {
    private final ClockProxy clock;
    private final PasswordManager passwordManager;
    private final AdminDataRecordCountService dataRecordCountService;
    private final AdminUserKeywordService userKeywordService;
    private final AdminUserRoleService userRoleService;
    private final AdminUserRepository userRepository;
    private final AdminUserMetaService userMetaService;
    private final AdminUserAccessTokenRepository accessTokenRepository;
    private final AdminEntityToModelConverter entityToModelConverter;
    private final AdminModelToEntityConverter modelToEntityConverter;

    public AdminUserService(ClockProxy clock, PasswordManager passwordManager, AdminDataRecordCountService dataRecordCountService, AdminUserAccessTokenService userAccessTokenService, AdminUserKeywordService userKeywordService, AdminUserRoleService userRoleService, AdminUserRepository userRepository, AdminUserMetaService userMetaService, AdminUserAccessTokenRepository accessTokenRepository, AdminEntityToModelConverter entityToModelConverter, AdminModelToEntityConverter modelToEntityConverter, AdminResultToModelConverter resultToModelConverter) {
        super(clock, (UserAccessTokenService)userAccessTokenService, (UserRepository)userRepository, (UserAccessTokenRepository)accessTokenRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter, (DefaultResultToModelConverter)resultToModelConverter);
        this.clock = clock;
        this.passwordManager = passwordManager;
        this.dataRecordCountService = dataRecordCountService;
        this.userKeywordService = userKeywordService;
        this.userRoleService = userRoleService;
        this.userRepository = userRepository;
        this.userMetaService = userMetaService;
        this.accessTokenRepository = accessTokenRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }

    public UserModel addUser(AddUserModel model) {
        User entity = this.modelToEntityConverter.toEntity(model);
        this.userRepository.save(entity);
        this.saveUserRoles(entity.getId(), model.getRoleIds());
        return this.entityToModelConverter.toModel(entity);
    }

    public UserModel addUserIfNotExists(AddUserModel model) {
        String phone;
        String email;
        User entity = null;
        String username = model.getUsername();
        if (EzyStrings.isNotBlank((String)username)) {
            entity = (User)this.userRepository.findByField("username", username);
        }
        if (entity == null && EzyStrings.isNotBlank((String)(email = model.getEmail()))) {
            entity = (User)this.userRepository.findByField("email", email);
        }
        if (entity == null && EzyStrings.isNotBlank((String)(phone = model.getPhone()))) {
            entity = (User)this.userRepository.findByField("phone", phone);
        }
        return entity == null ? this.addUser(model) : this.entityToModelConverter.toModel(entity);
    }

    public void updateUser(UpdateUserModel model) {
        User entity = this.getUserEntityByUsernameOrThrow(model.getUsername());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.userRepository.save(entity);
        this.saveUserRoles(entity.getId(), model.getRoleIds());
    }

    public void updatePassword(String username, String oldPassword, String newPassword) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        if (!this.passwordManager.isMatchingPassword(oldPassword, entity.getPassword())) {
            throw IncorrectPasswordException.ofUserName((String)username);
        }
        entity.setPassword(this.passwordManager.hashPassword(newPassword));
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void updatePassword(String username, String newPassword) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        entity.setPassword(this.passwordManager.hashPassword(newPassword));
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public String generateForgotPasswordToken(long userId, String username) {
        String token = Sha256Uuids.generateUuid((String)(userId + username));
        this.userMetaService.saveUserMetaUniqueKey(userId, "forgotPasswordToken", token);
        return token;
    }

    public void updateAvatar(String username, long avatarId) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        entity.setAvatarImageId(avatarId);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void updateCoverImage(String username, long coverImageId) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        entity.setCoverImageId(coverImageId);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void archiveUser(String username) {
        this.updateInactivateUserStatus(username, UserStatus.ARCHIVED.toString());
    }

    public void blockUser(String username) {
        this.updateInactivateUserStatus(username, UserStatus.BLOCKED.toString());
    }

    public void updateInactivateUserStatus(String username, String status) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        this.removeUserAccessToken(entity.getId());
        entity.setStatus(status);
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void archiveUsers(Collection<Long> userIds) {
        List entities = this.userRepository.findListByIds(userIds);
        this.removeUserAccessTokens(userIds);
        entities.forEach(entity -> {
            entity.setStatus(UserStatus.ARCHIVED.toString());
            entity.setUpdatedAt(this.clock.nowDateTime());
        });
        this.userRepository.save(entities);
    }

    public void activateUser(String username) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        entity.setStatus(AdminStatus.ACTIVATED.toString());
        entity.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(entity);
    }

    public void activateUsers(Collection<Long> userIds) {
        List entities = this.userRepository.findListByIds(userIds);
        entities.forEach(entity -> {
            entity.setStatus(AdminStatus.ACTIVATED.toString());
            entity.setUpdatedAt(this.clock.nowDateTime());
        });
        this.userRepository.save(entities);
    }

    public void eraseUser(String username) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        long userId = entity.getId();
        this.modelToEntityConverter.toDeletedUserEntity(entity);
        this.userRepository.save(entity);
        this.removeUserComponents(userId);
    }

    public void eraseUsers(Collection<Long> userIds) {
        List entities = this.userRepository.findListByIds(userIds);
        entities.forEach(this.modelToEntityConverter::toDeletedUserEntity);
        this.userRepository.save(entities);
        this.removeUsersComponents(userIds);
    }

    public void removeUser(String username) {
        User entity = this.getUserEntityByUsernameOrThrow(username);
        long userId = entity.getId();
        this.userRepository.delete(userId);
        this.removeUserComponents(userId);
        this.decrementUserRecordCount(1L);
    }

    public void removeUsers(Collection<Long> userIds) {
        this.userRepository.deleteByIds(userIds);
        this.removeUsersComponents(userIds);
        this.decrementUserRecordCount(userIds.size());
    }

    private void removeUserComponents(long userId) {
        this.removeUserAccessToken(userId);
        this.userRoleService.removeUserRoles(userId);
        this.userKeywordService.removeUserKeywords(userId);
    }

    private void removeUsersComponents(Collection<Long> userIds) {
        this.removeUserAccessTokens(userIds);
        this.userRoleService.removeUsersRoles(userIds);
        this.userKeywordService.removeUsersKeywords(userIds);
    }

    public void removeUserAccessTokens(Collection<Long> userIds) {
        this.accessTokenRepository.deleteByUserIdIn(userIds);
    }

    public void decrementUserRecordCount(long value) {
        this.dataRecordCountService.decrementRecordCount("ezy_users", value);
    }

    public long getUserRecordCount() {
        return this.dataRecordCountService.getRecordCount("ezy_users");
    }

    private void saveUserRoles(long userId, Set<Long> roleIds) {
        this.userRoleService.replaceUserRoles(userId, roleIds);
    }

    private User getUserEntityByUsernameOrThrow(String username) {
        User entity = this.getUserEntityByUsername(username);
        if (entity == null) {
            throw new UserNotFoundException(username);
        }
        return entity;
    }

    private User getUserEntityByUsername(String username) {
        return (User)this.userRepository.findByField("username", username);
    }
}

