/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.view;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import com.tvd12.ezyhttp.server.core.util.HttpServletRequests;
import com.tvd12.ezyhttp.server.core.view.View;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import com.tvd12.ezyhttp.server.core.view.ViewDecorator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.youngmonkeys.ezyplatform.admin.data.Menu;
import org.youngmonkeys.ezyplatform.admin.data.MenuItem;
import org.youngmonkeys.ezyplatform.admin.event.AdminEventHandlerManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEnvironmentManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEzyPlatformManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMenuManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminTargetManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminLanguageService;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminRoleFeatureService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.pagination.MediaPaginationSortOrder;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.util.HttpRequests;
import org.youngmonkeys.ezyplatform.util.OS;

@EzySingleton
public class AdminViewDecorator
implements ViewDecorator {
    private final AdminMenuManager menuManager;
    private final AdminModuleManager moduleManager;
    private final FeatureURIManager featureUriManager;
    private final AdminMarketUrlManager marketUrlManager;
    private final AdminEventHandlerManager eventHandlerManager;
    private final AdminEnvironmentManager environmentManager;
    private final AdminEzyPlatformManager ezyPlatformManager;
    private final AdminTargetManager targetManager;
    private final AdminAdminService adminService;
    private final AdminLanguageService adminLanguageService;
    private final AdminAdminRoleService adminRoleService;
    private final AdminMediaService mediaService;
    private final AdminRoleFeatureService roleFeatureService;
    private final AdminSettingService settingService;
    private final AdminUserService userService;
    private final AdminUserRoleService userRoleService;
    private final EzyLazyInitializer<ViewContext> viewContext;

    public AdminViewDecorator(AdminMenuManager menuManager, AdminModuleManager moduleManager, FeatureURIManager featureUriManager, AdminMarketUrlManager marketUrlManager, AdminEventHandlerManager eventHandlerManager, AdminEnvironmentManager environmentManager, AdminEzyPlatformManager ezyPlatformManager, AdminTargetManager targetManager, AdminAdminService adminService, AdminAdminRoleService adminRoleService, AdminRoleFeatureService roleFeatureService, AdminUserService userService, AdminUserRoleService userRoleService, AdminMediaService mediaService, AdminSettingService settingService, AdminLanguageService adminLanguageService, EzySingletonFactory singletonFactory) {
        this.menuManager = menuManager;
        this.moduleManager = moduleManager;
        this.featureUriManager = featureUriManager;
        this.marketUrlManager = marketUrlManager;
        this.eventHandlerManager = eventHandlerManager;
        this.environmentManager = environmentManager;
        this.ezyPlatformManager = ezyPlatformManager;
        this.targetManager = targetManager;
        this.adminService = adminService;
        this.adminRoleService = adminRoleService;
        this.roleFeatureService = roleFeatureService;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.mediaService = mediaService;
        this.settingService = settingService;
        this.adminLanguageService = adminLanguageService;
        this.viewContext = new EzyLazyInitializer(() -> (ViewContext)singletonFactory.getSingletonCast(ViewContext.class));
    }

    public void decorate(HttpServletRequest request, View view) {
        String matchedUri = (String)request.getAttribute("ezyAttributeMatchedURI");
        if (matchedUri == null) {
            matchedUri = request.getRequestURI();
        }
        this.setLanguages(view);
        this.setLanguage(request, view);
        this.setCommonVariables(view);
        this.setAdminData(request, view);
        this.setModuleVariable(view);
        this.setMenuVariables(view, matchedUri);
        this.setDateTimeFormatVariables(view);
        this.setAdditionValues(view);
        this.setMessages(view);
        this.setMissingVariables(view);
    }

    private void setLanguages(View view) {
        view.setVariable("adminLanguages", this.adminLanguageService.getLanguages());
    }

    private void setLanguage(HttpServletRequest request, View view) {
        String lang = HttpRequests.getLanguage((HttpServletRequest)request);
        if (EzyStrings.isBlank((String)lang)) {
            lang = this.adminLanguageService.getDefaultLanguageCode();
            if (EzyStrings.isNotBlank((String)lang)) {
                view.setLocale(new Locale(lang));
                view.setVariable("ezyDefaultLang", (Object)lang);
            }
        } else {
            view.setLocale(new Locale(lang));
            view.setVariable("ezyLang", (Object)lang);
        }
    }

    private void setCommonVariables(View view) {
        Reactive.multiple().register((Object)"webUrl", () -> ((AdminSettingService)this.settingService).getWebUrl()).register((Object)"websocketUrl", () -> ((AdminSettingService)this.settingService).getWebsocketUrl()).register((Object)"ezyplatformUrl", () -> ((AdminMarketUrlManager)this.marketUrlManager).getEzyplatformUrl()).register((Object)"platformVersion", () -> ((AdminEnvironmentManager)this.environmentManager).getPlatformVersion()).register((Object)"hasNewPlatformVersion", this.ezyPlatformManager::hasNewVersion).register((Object)"debugEnabled", () -> ((AdminEnvironmentManager)this.environmentManager).isDebugMode()).register((Object)"osType", OS::currentType).register((Object)"searchMediaTypes", () -> ((AdminMediaService)this.mediaService).getAllMediaTypes()).register((Object)"searchMediaStatuses", () -> ((AdminMediaService)this.mediaService).getAllMediaStatuses()).register((Object)"searchMediaSortOrders", MediaPaginationSortOrder::values).register((Object)"numberOfMediaPerPage", this.settingService::getNumberOfMediaPerPage).register((Object)"paginationCountLimit", () -> ((AdminSettingService)this.settingService).getPaginationCountLimit()).register((Object)"ezyplatformLogoUrl", this.settingService::getAdminEzyPlatformLogoUrl).register((Object)"ezyPlatformCopyright", this.settingService::getAdminEzyPlatformCopyright).blockingConsume(it -> view.setVariables(it.valueMap()));
        view.setVariable("commonMediaTypes", (Object)MediaType.values());
        view.setVariableIfAbsent("ezyResourceVersion", (Object)this.environmentManager.getServerStartTime());
        String mediaModalTemplate = (String)this.eventHandlerManager.handleEvent("get_media_modal_template", CommonConstants.NULL_OBJECT);
        view.setVariable("ezyMediaModalTemplate", (Object)(EzyStrings.isBlank((String)mediaModalTemplate) ? "media/modal" : mediaModalTemplate));
    }

    private void setModuleVariable(View view) {
        view.setVariable("totalAdminPlugin", (Object)this.moduleManager.getModuleCount(ModuleType.ADMIN_PLUGIN));
        view.setVariable("totalWebPlugin", (Object)this.moduleManager.getModuleCount(ModuleType.WEB_PLUGIN));
        view.setVariable("totalTheme", (Object)this.moduleManager.getModuleCount(ModuleType.THEME));
        view.setVariable("totalSocketPlugin", (Object)this.moduleManager.getModuleCount(ModuleType.SOCKET_PLUGIN));
        view.setVariable("totalSocketApp", (Object)this.moduleManager.getModuleCount(ModuleType.SOCKET_APP));
        if (!view.containsVariable("totalUser")) {
            view.setVariable("totalUser", (Object)this.userService.getUserRecordCount());
        }
        Long adminId = (Long)view.getVariable("adminId");
        Reactive.multiple().register((Object)"totalAdmin", this.adminService::countAllAdmins).register((Object)"totalSetting", this.settingService::countAllSettings).register((Object)"totalAdminRoles", () -> adminId != null ? this.adminRoleService.countAdminVisibleRoles(adminId) : 0L).register((Object)"totalUserRoles", this.userRoleService::countAllRoles).register((Object)"socketEnable", () -> this.targetManager.isEnableTargetByType(TargetType.SOCKET)).blockingConsume(it -> view.setVariables(it.valueMap()));
    }

    private void setMenuVariables(View view, String matchedUri) {
        view.setVariable("topMenus", (Object)this.menuManager.getTopSection());
        view.setVariable("componentsMenus", (Object)this.menuManager.getComponentsSection());
        view.setVariable("administratorMenus", (Object)this.menuManager.getAdministratorSection());
        view.setVariable("extensionsMenus", (Object)this.menuManager.getExtensionsSection());
        this.setMenuSelectionVariables(view, matchedUri);
        view.setVariableIfAbsent("menuBadges", HashMap::new);
        view.setVariableIfAbsent("menuItemBadges", HashMap::new);
    }

    private void setMenuSelectionVariables(View view, String matchedUri) {
        Menu menu = this.menuManager.getMenuByUri(matchedUri);
        if (menu != null) {
            view.setVariableIfAbsent("currentMenu", (Object)menu.getFullName());
            view.setVariableIfAbsent("currentParentTitle", (Object)"home.title");
            view.setVariableIfAbsent("currentParentURL", (Object)"/");
            view.setVariableIfAbsent("currentPageTitle", (Object)menu.getName());
            return;
        }
        MenuItem menuItem = this.menuManager.getMenuItemByUri(matchedUri);
        if (menuItem != null) {
            Menu parentMenu = this.menuManager.getMenuByFullName(menuItem.getMenuFullName());
            view.setVariableIfAbsent("currentMenu", (Object)menuItem.getFullName());
            view.setVariableIfAbsent("currentParentTitle", (Object)parentMenu.getFullName());
            view.setVariableIfAbsent("currentParentURL", (Object)parentMenu.getUri());
            view.setVariableIfAbsent("currentPageTitle", (Object)menuItem.getName());
            view.setVariableIfAbsent("currentOpen", (Object)parentMenu.getFullName());
        }
    }

    private void setAdminData(HttpServletRequest request, View view) {
        Long adminId = (Long)request.getAttribute(AdminId.class.getName());
        AdminRolesProxy adminRoles = (AdminRolesProxy)request.getAttribute(AdminRoles.class.getName());
        if (adminId == null) {
            String accessToken = HttpServletRequests.getRequestValue((HttpServletRequest)request, (String)"adminAccessToken");
            if (EzyStrings.isNotBlank((String)accessToken)) {
                adminId = this.adminService.getAdminIdByAccessToken(accessToken);
            }
            if (adminId != null) {
                adminRoles = this.getAdminRoles(adminId);
            }
        }
        if (adminId == null) {
            return;
        }
        view.setVariable("adminId", (Object)adminId);
        AdminModel admin = (AdminModel)view.getVariable("admin");
        if (admin == null) {
            admin = this.adminService.getAdminById(adminId);
        }
        if (admin != null) {
            view.setVariable("admin", (Object)admin);
            view.setVariable("loggedIn", (Object)Boolean.TRUE);
            view.setVariable("adminRoles", (Object)adminRoles);
            MediaNameModel avatarImage = (MediaNameModel)view.getVariable("avatarImage");
            if (avatarImage == null) {
                avatarImage = this.mediaService.getMediaNameById(admin.getAvatarImageId());
                view.setVariable("avatarImage", (Object)avatarImage);
            }
        }
    }

    private AdminRolesProxy getAdminRoles(long adminId) {
        return AdminRolesProxy.create(this.adminRoleService.getRoleIdsByAdminId(adminId), (long)this.adminRoleService.getSuperAdminRoleId(), this.adminRoleService.getSpecialRoleIds(), (FeatureURIManager)this.featureUriManager, (Map)this.roleFeatureService.getMethodsUriMapByFeatureByRoleId());
    }

    private void setDateTimeFormatVariables(View view) {
        view.setVariableIfAbsent("defaultDateFormat", this.settingService::getAdminDateFormat);
        view.setVariableIfAbsent("defaultTimeFormat", this.settingService::getAdminTimeFormat);
        view.setVariableIfAbsent("defaultDateTimeFormat", this.settingService::getAdminDateTimeFormat);
        view.setVariableIfAbsent("defaultDateMinuteFormat", this.settingService::getAdminDateMinuteFormat);
    }

    private void setAdditionValues(View view) {
        view.setVariableIfAbsent("additionalValueMap", new HashMap());
    }

    private void setMessages(View view) {
        view.setVariableIfAbsent("additionalMessageMap", new HashMap());
        Collection keysFromView = (Collection)view.getVariable("additionalMessageKeys");
        if (keysFromView != null) {
            ViewContext viewContext = (ViewContext)this.viewContext.get();
            view.putKeyValuesToVariable("additionalMessageMap", viewContext.resolveMessages(view.getLocale(), keysFromView));
        }
    }

    private void setMissingVariables(View view) {
        view.setVariableIfAbsent("currentPageTitle", (Object)"unknown");
        view.setVariableIfAbsent("currentParentTitle", (Object)"unknown");
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

