/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket.controller;

import com.tvd12.ezyfoxserver.config.EzyConfig;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.controller.EzyAbstractServerEventController;
import com.tvd12.ezyfoxserver.event.EzyServerReadyEvent;
import com.tvd12.ezyfoxserver.ssl.EzySslContextProxy;
import java.io.File;
import java.nio.file.Paths;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.socket.util.EzyServerContexts;

public class SocketGlobalServerReadyEventHandler
extends EzyAbstractServerEventController<EzyServerReadyEvent> {
    private static final int DEFAULT_AUTO_RELOAD_SSL_SLEEP_TIME = 5000;
    private static final String FILE_KEYSTORE_SOCKET = "socket/settings/ssl/ssl-keystore.txt";

    public void handle(EzyServerContext serverContext, EzyServerReadyEvent serverReadyEvent) {
        this.logger.info("socket server start successfully!!!");
        this.startAutoReloadSslContextThread(serverContext.getServer().getConfig(), EzyServerContexts.getSettingServiceFromServerContext(serverContext), (EzySslContextProxy)serverContext.getProperty(EzySslContextProxy.class));
    }

    private void startAutoReloadSslContextThread(EzyConfig config, SettingService settingService, EzySslContextProxy sslContextProxy) {
        boolean autoReloadEnable;
        int sleepTime;
        if (settingService == null) {
            sleepTime = 5000;
            autoReloadEnable = true;
        } else {
            sleepTime = settingService.getIntValue("socket_auto_reload_sleep_time", 5000);
            autoReloadEnable = settingService.getBooleanValue("socket_auto_reload_ssl_enable", true);
        }
        String platformHomePath = Paths.get(config.getEzyfoxHome(), new String[0]).toAbsolutePath().getParent().toString();
        File keystoreFile = Paths.get(platformHomePath, FILE_KEYSTORE_SOCKET).toFile();
        this.logger.info("start reload ssl context thread, enable: {}, sleep time: {}, settingService: {}, sslContextProxy: {}", new Object[]{autoReloadEnable, sleepTime, settingService, sslContextProxy});
        Thread thread = new Thread(() -> {
            long keystoreLastModified = System.currentTimeMillis();
            while (true) {
                long lastModified;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (!autoReloadEnable || (lastModified = keystoreFile.lastModified()) <= keystoreLastModified) continue;
                keystoreLastModified = lastModified;
                this.logger.info("start reload ssl context");
                sslContextProxy.reloadSsl();
                this.logger.info("end reload ssl context");
            }
        });
        thread.setName("auto-reload-ssl-context");
        thread.start();
    }
}

