/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.entity;

import com.tvd12.ezyfox.util.EzyEnums;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import java.util.Map;
import lombok.Generated;

public enum MediaType {
    AUDIO("audio", "audio", "audios"),
    AVATAR("avatar", "avatar", "avatars"),
    DOCUMENT("application", "document", "files"),
    FONT("font", "font", "fonts"),
    FILE("file", "file", "files"),
    IMAGE("image", "image", "images"),
    VIDEO("video", "video", "videos");

    private final String name;
    private final String mimeTypeName;
    private final String folder;
    private static final Map<String, MediaType> MAP_BY_NAME;
    private static final Map<String, MediaType> MAP_BY_MIME_TYPE_NAME;

    private MediaType(String mimeTypeName, String name, String folder) {
        this.name = name;
        this.mimeTypeName = mimeTypeName;
        this.folder = folder;
    }

    public static MediaType ofName(String name) {
        MediaType answer = name == null ? null : MAP_BY_NAME.get(name);
        return answer == null ? FILE : answer;
    }

    public static MediaType ofMimeTypeName(String name) {
        MediaType answer = name == null ? null : MAP_BY_MIME_TYPE_NAME.get(name);
        return answer == null ? FILE : answer;
    }

    public boolean equalsValue(String value) {
        return this.toString().equals(value);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMimeTypeName() {
        return this.mimeTypeName;
    }

    @Generated
    public String getFolder() {
        return this.folder;
    }

    static {
        MAP_BY_NAME = EzyMapBuilder.mapBuilder().putAll(EzyEnums.enumMap(MediaType.class, it -> it.name)).putAll(EzyEnums.enumMap(MediaType.class, Enum::toString)).toMap();
        MAP_BY_MIME_TYPE_NAME = EzyEnums.enumMap(MediaType.class, it -> it.name);
    }
}

