/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.exception;

import java.util.Collections;
import org.youngmonkeys.ezyplatform.exception.BadRequestException;
import org.youngmonkeys.ezyplatform.util.Strings;

public class IncorrectPasswordException
extends BadRequestException {
    public IncorrectPasswordException() {
        this("password");
    }

    public IncorrectPasswordException(String passwordField) {
        super(Collections.singletonMap(passwordField, "incorrect"));
    }

    public IncorrectPasswordException(String passwordField, String msg) {
        super(Collections.singletonMap(passwordField, "incorrect"), msg);
    }

    public static IncorrectPasswordException ofUserId(long userId) {
        return new IncorrectPasswordException("password", "Incorrect password of user: " + userId);
    }

    public static IncorrectPasswordException ofUserName(String username) {
        return new IncorrectPasswordException("password", "Incorrect password of user: " + Strings.hideSensitiveInformation(username, 2, 6));
    }

    public static IncorrectPasswordException ofAdminId(long adminId) {
        return new IncorrectPasswordException("password", "Incorrect password of admin: " + adminId);
    }
}

