/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.youngmonkeys.ezyplatform.data.ImageSize;

public final class ImageProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageProxy.class);

    private ImageProxy() {
    }

    public static ImageSize getImageSize(Path imageFilePath) {
        return ImageProxy.getImageSize(imageFilePath.toFile());
    }

    public static ImageSize getImageSize(String imageFilePath) throws IOException {
        return ImageProxy.getImageSize(new File(imageFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static ImageSize getImageSize(File imageFile) {
        block19: {
            try {
                Throwable throwable = null;
                try (ImageInputStream inputStream = ImageIO.createImageInputStream(imageFile);){
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(inputStream);
                    if (!readers.hasNext()) break block19;
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(inputStream);
                        ImageSize imageSize = new ImageSize(reader.getWidth(0), reader.getHeight(0), imageFile.length());
                        reader.dispose();
                        return imageSize;
                    }
                    catch (Throwable throwable2) {
                        try {
                            reader.dispose();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.info("can not read size of image: {}, error: {} ({})", new Object[]{imageFile, e.getClass(), e.getMessage()});
            }
        }
        return new ImageSize(0, 0, imageFile.length());
    }
}

