/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyfox.io.EzyStrings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.fetcher.CommonEntityFetcher;
import org.youngmonkeys.ezyplatform.model.CommonEntityModel;

public class CommonEntityFetcherManager {
    private final EzyLazyInitializer<Map<String, CommonEntityFetcher>> accountingEntityFetcherByEntityType = new EzyLazyInitializer(() -> {
        List beans = singletonFactory.getSingletonsOf(CommonEntityFetcher.class);
        Map<String, CommonEntityFetcher> map = CommonEntityFetcherManager.extractEntityFetcherMap(beans);
        List<CommonEntityFetcher> prioritizedBeans = this.getPrioritizedEntityFetchers(singletonFactory);
        for (CommonEntityFetcher fetcher : prioritizedBeans) {
            if (EzyStrings.isNotBlank((String)fetcher.getModuleName())) continue;
            for (String entityType : fetcher.getEntityTypes()) {
                map.put(entityType, fetcher);
            }
        }
        return map;
    });
    private final EzyLazyInitializer<Map<String, Map<String, CommonEntityFetcher>>> accountingEntityFetcherByEntityTypeByModuleName = new EzyLazyInitializer(() -> {
        List beans = singletonFactory.getSingletonsOf(CommonEntityFetcher.class);
        Map<String, Map<String, CommonEntityFetcher>> map = CommonEntityFetcherManager.extractModuleEntityFetcherMap(beans);
        List<CommonEntityFetcher> prioritizedBeans = this.getPrioritizedEntityFetchers(singletonFactory);
        for (CommonEntityFetcher fetcher : prioritizedBeans) {
            String moduleName = fetcher.getModuleName();
            if (EzyStrings.isBlank((String)moduleName)) continue;
            for (String entityType : fetcher.getEntityTypes()) {
                map.computeIfAbsent(moduleName, k -> new ConcurrentHashMap()).put(entityType, fetcher);
            }
        }
        return map;
    });
    private final Map<String, CommonEntityFetcher> additionalFetcherByEntityType = new ConcurrentHashMap<String, CommonEntityFetcher>();
    private final Map<String, Map<String, CommonEntityFetcher>> additionalFetcherByEntityTypeByModuleName = new ConcurrentHashMap<String, Map<String, CommonEntityFetcher>>();

    public CommonEntityFetcherManager(EzySingletonFactory singletonFactory) {
    }

    private static Map<String, CommonEntityFetcher> extractEntityFetcherMap(List<CommonEntityFetcher> beans) {
        ConcurrentHashMap<String, CommonEntityFetcher> map = new ConcurrentHashMap<String, CommonEntityFetcher>();
        for (CommonEntityFetcher fetcher : beans) {
            if (EzyStrings.isNotBlank((String)fetcher.getModuleName())) continue;
            for (String entityType : fetcher.getEntityTypes()) {
                map.compute(entityType, (k, v) -> v == null || fetcher.getPriority() >= v.getPriority() ? fetcher : v);
            }
        }
        return map;
    }

    private static Map<String, Map<String, CommonEntityFetcher>> extractModuleEntityFetcherMap(List<CommonEntityFetcher> beans) {
        ConcurrentHashMap<String, Map<String, CommonEntityFetcher>> map = new ConcurrentHashMap<String, Map<String, CommonEntityFetcher>>();
        for (CommonEntityFetcher fetcher : beans) {
            String moduleName = fetcher.getModuleName();
            if (EzyStrings.isBlank((String)moduleName)) continue;
            for (String entityType : fetcher.getEntityTypes()) {
                map.computeIfAbsent(moduleName, k -> new ConcurrentHashMap()).compute(entityType, (k, v) -> v == null || fetcher.getPriority() >= v.getPriority() ? fetcher : v);
            }
        }
        return map;
    }

    protected List<CommonEntityFetcher> getPrioritizedEntityFetchers(EzySingletonFactory singletonFactory) {
        return Collections.emptyList();
    }

    public void addEntityFetcher(CommonEntityFetcher fetcher) {
        String moduleName = fetcher.getModuleName();
        if (EzyStrings.isBlank((String)moduleName)) {
            for (String entityType : fetcher.getEntityTypes()) {
                this.additionalFetcherByEntityType.put(entityType, fetcher);
            }
        } else {
            for (String entityType : fetcher.getEntityTypes()) {
                this.additionalFetcherByEntityTypeByModuleName.computeIfAbsent(moduleName, k -> new ConcurrentHashMap()).put(entityType, fetcher);
            }
        }
    }

    public CommonEntityFetcher getEntityFetcherByModuleNameAndEntityType(String moduleName, String entityType) {
        CommonEntityFetcher fetcher = (CommonEntityFetcher)this.additionalFetcherByEntityTypeByModuleName.getOrDefault(moduleName, Collections.emptyMap()).get(entityType);
        if (fetcher == null) {
            fetcher = (CommonEntityFetcher)((Map)this.accountingEntityFetcherByEntityTypeByModuleName.get()).getOrDefault(moduleName, Collections.emptyMap()).get(entityType);
        }
        if (fetcher == null) {
            fetcher = this.getEntityFetcherByEntityType(entityType);
        }
        return fetcher;
    }

    public CommonEntityFetcher getEntityFetcherByEntityType(String entityType) {
        CommonEntityFetcher fetcher = this.additionalFetcherByEntityType.get(entityType);
        if (fetcher == null) {
            fetcher = (CommonEntityFetcher)((Map)this.accountingEntityFetcherByEntityType.get()).get(entityType);
        }
        return fetcher;
    }

    public CommonEntityModel getEntityByModuleNameAndEntityTypeAndId(String moduleName, String entityType, long entityId) {
        CommonEntityFetcher fetcher = this.getEntityFetcherByModuleNameAndEntityType(moduleName, entityType);
        return fetcher != null ? fetcher.getEntityById(entityId) : CommonEntityModel.defaultEntity(entityId, entityType);
    }

    public CommonEntityModel getEntityByEntityTypeAndId(String entityType, long entityId) {
        CommonEntityFetcher fetcher = this.getEntityFetcherByEntityType(entityType);
        return fetcher != null ? fetcher.getEntityById(entityId) : CommonEntityModel.defaultEntity(entityId, entityType);
    }

    public Map<Long, CommonEntityModel> getEntityMapByModuleNameAndEntityTypeAndIds(String moduleName, String entityType, Collection<Long> entityIds) {
        CommonEntityFetcher fetcher = this.getEntityFetcherByModuleNameAndEntityType(moduleName, entityType);
        return fetcher != null ? fetcher.getEntityMapByIds(entityIds) : Collections.emptyMap();
    }

    public Map<Long, CommonEntityModel> getEntityMapByEntityTypeAndIds(String entityType, Collection<Long> entityIds) {
        CommonEntityFetcher fetcher = this.getEntityFetcherByEntityType(entityType);
        return fetcher != null ? fetcher.getEntityMapByIds(entityIds) : Collections.emptyMap();
    }

    public Map<String, Map<Long, CommonEntityModel>> getEntityMapByModuleNameAndEntityIdsByType(String moduleName, Map<String, Set<Long>> entityIdsByType) {
        return entityIdsByType.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getEntityMapByModuleNameAndEntityTypeAndIds(moduleName, (String)e.getKey(), (Collection)e.getValue())));
    }

    public Map<String, Map<Long, CommonEntityModel>> getEntityMapByEntityIdsByType(Map<String, Set<Long>> entityIdsByType) {
        return entityIdsByType.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getEntityMapByEntityTypeAndIds((String)e.getKey(), (Collection)e.getValue())));
    }

    public Set<String> getAllEntityTypes() {
        return EzySets.combine((Collection[])new Collection[]{((Map)this.accountingEntityFetcherByEntityType.get()).keySet(), this.additionalFetcherByEntityType.keySet(), ((Map)this.accountingEntityFetcherByEntityTypeByModuleName.get()).values().stream().flatMap(it -> it.keySet().stream()).collect(Collectors.toSet()), this.additionalFetcherByEntityTypeByModuleName.values().stream().flatMap(it -> it.keySet().stream()).collect(Collectors.toSet())});
    }

    public Set<String> getAllModelNames() {
        return EzySets.combine((Collection[])new Collection[]{EzySets.newHashSet(((Map)this.accountingEntityFetcherByEntityType.get()).values(), CommonEntityFetcher::getModelName), EzySets.newHashSet(this.additionalFetcherByEntityType.values(), CommonEntityFetcher::getModelName), ((Map)this.accountingEntityFetcherByEntityTypeByModuleName.get()).values().stream().flatMap(it -> it.values().stream().map(CommonEntityFetcher::getModelName)).collect(Collectors.toSet()), this.additionalFetcherByEntityTypeByModuleName.values().stream().flatMap(it -> it.values().stream().map(CommonEntityFetcher::getModelName)).collect(Collectors.toSet())});
    }
}

