/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.repo;

import com.tvd12.ezydata.database.EzyDatabaseRepository;
import com.tvd12.ezyfox.database.annotation.EzyQuery;
import com.tvd12.ezyfox.util.Next;
import java.util.Collection;
import java.util.List;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.result.IdNameResult;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.result.IdUuidNameResult;
import org.youngmonkeys.ezyplatform.result.IdUuidResult;
import org.youngmonkeys.ezyplatform.result.StatusResult;

public interface UserRepository
extends EzyDatabaseRepository<Long, User> {
    @EzyQuery(value="SELECT DISTINCT e.status FROM User e")
    public List<StatusResult> findAllUserStatuses();

    @EzyQuery(value="SELECT e.status FROM User e WHERE e.id = ?0")
    public StatusResult findStatusById(long var1);

    @EzyQuery(value="SELECT e.id FROM User e WHERE e.username = ?0")
    public IdResult findUserIdByUsername(String var1);

    @EzyQuery(value="SELECT e.id FROM User e WHERE e.email = ?0")
    public IdResult findUserIdByEmail(String var1);

    @EzyQuery(value="SELECT e.id FROM User e WHERE e.phone = ?0")
    public IdResult findUserIdByPhone(String var1);

    @EzyQuery(value="SELECT e.id FROM User e WHERE e.uuid = ?0")
    public IdResult findUserIdByUuid(String var1);

    @EzyQuery(value="SELECT e.id FROM User e WHERE e.id > ?0")
    public List<IdResult> findIdByIdGt(long var1, Next var3);

    @EzyQuery(value="SELECT e.id, e.uuid FROM User e WHERE e.uuid IN ?0")
    public List<IdUuidResult> findUserIdsByUuids(Collection<String> var1);

    @EzyQuery(value="SELECT e.id, e.username, e.displayName FROM User e WHERE e.id = ?0")
    public IdNameResult findUserIdAndNameById(long var1);

    @EzyQuery(value="SELECT e.id, e.username, e.displayName FROM User e WHERE e.username = ?0")
    public IdNameResult findUserIdAndNameByUsername(String var1);

    @EzyQuery(value="SELECT e.id, e.username, e.displayName FROM User e WHERE e.id IN ?0")
    public List<IdNameResult> findUserIdAndNameByIds(Collection<Long> var1);

    @EzyQuery(value="SELECT e.id, e.username, e.displayName FROM User e WHERE e.username IN ?0")
    public List<IdNameResult> findUserIdAndNameByUsernames(Collection<String> var1);

    @EzyQuery(value="SELECT e.id, e.uuid, e.displayName FROM User e WHERE e.id = ?0")
    public IdUuidNameResult findUserUuidNameById(long var1);

    @EzyQuery(value="SELECT e.id, e.uuid, e.displayName FROM User e WHERE e.id IN ?0")
    public List<IdUuidNameResult> findUserUuidNamesByIds(Collection<Long> var1);

    @EzyQuery(value="SELECT e.id, e.uuid, e.displayName FROM User e WHERE e.uuid = ?0")
    public IdUuidNameResult findUserUuidNameByUuid(String var1);

    public List<User> findByUsernameIn(Collection<String> var1);

    public List<User> findByPhoneIn(Collection<String> var1);

    public List<User> findByEmailIn(Collection<String> var1);

    public List<User> findByUuidIn(Collection<String> var1);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e WHERE e.phone = ?0 OR e.email = ?0 OR e.displayName = ?0 OR e.username = ?0")
    public List<IdNameResult> findUsernameByUniqueKeyword(String var1, Next var2);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e WHERE e.phone IN ?0 OR e.email IN ?0 OR e.displayName IN ?0 OR e.username IN ?0")
    public List<IdNameResult> findUsernameByUniqueKeywords(Collection<String> var1, Next var2);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e WHERE e.phone LIKE CONCAT('%',?0,'%') OR e.email LIKE CONCAT('%',?0,'%') OR e.displayName LIKE CONCAT('%',?0,'%') OR e.username LIKE CONCAT('%',?0,'%')")
    public List<IdNameResult> findUsernameByKeyword(String var1, Next var2);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserKeyword k ON e.id = k.userId WHERE k.keyword IN ?0")
    public List<IdNameResult> findUsernameByKeywords(Collection<String> var1, Next var2);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserKeyword k ON e.id = k.userId WHERE k.keyword LIKE CONCAT(?0,'%')")
    public List<IdNameResult> findUsernameByKeywordPrefix(String var1, Next var2);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserRole a ON e.id = a.userId WHERE a.roleId IN ?0 AND (e.phone LIKE CONCAT('%',?1,'%') OR e.email LIKE CONCAT('%',?1,'%') OR e.displayName LIKE CONCAT('%',?1,'%') OR e.username LIKE CONCAT('%',?1,'%'))")
    public List<IdNameResult> findUsernameByKeywordAndRoleIds(Collection<Long> var1, String var2, Next var3);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserRole a ON e.id = a.userId INNER JOIN UserKeyword b ON e.id = b.userId WHERE a.roleId IN ?0 AND b.keyword IN ?1")
    public List<IdNameResult> findUsernameByKeywordsAndRoleIds(Collection<Long> var1, Collection<String> var2, Next var3);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserRole a ON e.id = a.userId INNER JOIN UserKeyword b ON e.id = b.userId WHERE a.roleId IN ?0 AND b.keyword LIKE CONCAT(?1,'%')")
    public List<IdNameResult> findUsernameByKeywordPrefixAndRoleIds(Collection<Long> var1, String var2, Next var3);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserRole a ON e.id = a.userId INNER JOIN UserRoleName b ON b.id = a.roleId INNER JOIN UserKeyword c ON e.id = c.userId WHERE b.name IN ?0 AND (e.phone LIKE CONCAT('%',?1,'%') OR e.email LIKE CONCAT('%',?1,'%') OR e.displayName LIKE CONCAT('%',?1,'%') OR e.username LIKE CONCAT('%',?1,'%'))")
    public List<IdNameResult> findUsernameByKeywordAndRoleNames(Collection<String> var1, String var2, Next var3);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserRole a ON e.id = a.userId INNER JOIN UserRoleName b ON b.id = a.roleId INNER JOIN UserKeyword c ON e.id = c.userId WHERE b.name IN ?0 AND c.keyword IN ?1")
    public List<IdNameResult> findUsernameByKeywordsAndRoleNames(Collection<String> var1, Collection<String> var2, Next var3);

    @EzyQuery(value="SELECT DISTINCT(e.id), e.username, e.displayName FROM User e INNER JOIN UserRole a ON e.id = a.userId INNER JOIN UserRoleName b ON b.id = a.roleId INNER JOIN UserKeyword c ON e.id = c.userId WHERE b.name IN ?0 AND c.keyword LIKE CONCAT(?1,'%')")
    public List<IdNameResult> findUsernameByKeywordPrefixAndRoleNames(Collection<String> var1, String var2, Next var3);

    public long countByStatus(String var1);
}

