/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataRecordCount;
import org.youngmonkeys.ezyplatform.repo.DataRecordCountRepository;
import org.youngmonkeys.ezyplatform.result.CountResult;
import org.youngmonkeys.ezyplatform.service.DataRecordCountService;

public class DefaultDataRecordCountService
implements DataRecordCountService {
    private final DataRecordCountRepository dataRecordCountRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void createDataRecordCountIfNotExists(String dataType) {
        DataRecordCount entity = (DataRecordCount)this.dataRecordCountRepository.findById(dataType);
        if (entity == null) {
            entity = this.modelToEntityConverter.toNewDataRecordCount(dataType);
            this.dataRecordCountRepository.save(entity);
        }
    }

    @Override
    public void incrementRecordCount(String dataType, long value) {
        this.createDataRecordCountIfNotExists(dataType);
        this.dataRecordCountRepository.updateRecordCountByDataType(dataType, value);
    }

    @Override
    public long getRecordCount(String dataType) {
        CountResult result = this.dataRecordCountRepository.findRecordCountByDataType(dataType);
        return result != null ? result.getCount() : 0L;
    }

    @Generated
    public DefaultDataRecordCountService(DataRecordCountRepository dataRecordCountRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.dataRecordCountRepository = dataRecordCountRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

