/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyMaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;
import org.youngmonkeys.ezyplatform.entity.UserStatus;
import org.youngmonkeys.ezyplatform.model.UserAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;
import org.youngmonkeys.ezyplatform.model.UuidNameModel;

public interface UserService {
    public UserModel getUserById(long var1);

    public UserModel getUserByUuid(String var1);

    public UserModel getUserByUsername(String var1);

    public UserModel getUserByEmail(String var1);

    public UserModel getUserByPhone(String var1);

    default public UserModel getUserByAccessToken(String accessToken) {
        return this.getUserByAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET);
    }

    public UserModel getUserByAccessToken(String var1, Set<String> var2);

    public String getUserStatusById(long var1);

    public List<UserModel> getUserListByIds(Collection<Long> var1);

    public List<UserModel> getUserListByUsernames(Collection<String> var1);

    public List<UserModel> getUserListByPhones(Collection<String> var1);

    public List<UserModel> getUserListByEmails(Collection<String> var1);

    public List<UserModel> getUserListByUuids(Collection<String> var1);

    public long getUserIdByUsername(String var1);

    public long getUserIdByEmail(String var1);

    public long getUserIdByPhone(String var1);

    public Long getUserIdByUuid(String var1);

    public Map<String, Long> getUserIdMapByUuids(Collection<String> var1);

    default public Long getUserIdByAccessToken(String accessToken) {
        return this.getUserIdByAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET);
    }

    public Long getUserIdByAccessToken(String var1, Set<String> var2);

    default public long validateUserAccessToken(String accessToken) {
        return this.validateUserAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET);
    }

    public long validateUserAccessToken(String var1, Set<String> var2);

    public UserAccessTokenModel getUserAccessTokenByAccessToken(String var1);

    default public UserAccessTokenModel getUserAccessTokenOrThrowByAccessToken(String accessToken, boolean verifyStatus) {
        return this.getUserAccessTokenOrThrowByAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET, verifyStatus);
    }

    public UserAccessTokenModel getUserAccessTokenOrThrowByAccessToken(String var1, Set<String> var2, boolean var3);

    default public UserAccessTokenModel getUserAccessTokenOrThrowByAccessToken(String accessToken) {
        return this.getUserAccessTokenOrThrowByAccessToken(accessToken, Boolean.FALSE);
    }

    public UserNameModel getUsernameById(long var1);

    public UserNameModel getUsernameByUsername(String var1);

    public Map<Long, UserNameModel> getUsernameMapByIds(Collection<Long> var1);

    public Map<String, UserNameModel> getUsernameMapByUsernames(Collection<String> var1);

    public UuidNameModel getUserUuidNameById(long var1);

    public Map<Long, UuidNameModel> getUserUuidNameMapByIds(Collection<Long> var1);

    public UuidNameModel getUserUuidNameByUuid(String var1);

    default public Map<Long, UserModel> getUserMapByIds(Collection<Long> userIds) {
        return EzyMaps.newHashMap(this.getUserListByIds(userIds), UserModel::getId);
    }

    default public Map<String, UserModel> getUserMapByUsernames(Collection<String> usernames) {
        return this.getUserListByUsernames(usernames).stream().filter(it -> it.getUsername() != null).collect(Collectors.toMap(UserModel::getUsername, it -> it));
    }

    default public Map<String, UserModel> getUserMapByEmails(Collection<String> emails) {
        return this.getUserListByEmails(emails).stream().filter(it -> it.getEmail() != null).collect(Collectors.toMap(UserModel::getEmail, it -> it));
    }

    default public Map<String, UserModel> getUserMapByPhones(Collection<String> phones) {
        return this.getUserListByPhones(phones).stream().filter(it -> it.getPhone() != null).collect(Collectors.toMap(UserModel::getPhone, it -> it));
    }

    default public Map<String, UserModel> getUserMapByUuids(Collection<String> uuids) {
        return this.getUserListByUuids(uuids).stream().filter(it -> it.getUuid() != null).collect(Collectors.toMap(UserModel::getUuid, it -> it));
    }

    public boolean containsUserById(long var1);

    public boolean containsUserByUsername(String var1);

    public long countUsersByStatus(String var1);

    public List<UserNameModel> simpleSearch(String var1, int var2);

    public List<UserNameModel> simpleSearch(Collection<String> var1, int var2);

    public List<UserNameModel> simpleSearchWithKeywordPrefix(String var1, int var2);

    public List<UserNameModel> simpleSearchWithRoleIds(Collection<Long> var1, String var2, int var3);

    public List<UserNameModel> simpleSearchWithRoleIds(Collection<Long> var1, Collection<String> var2, int var3);

    public List<UserNameModel> simpleSearchWithRoleIdsAndKeywordPrefix(Collection<Long> var1, String var2, int var3);

    public List<UserNameModel> simpleSearchWithRoleNames(Collection<String> var1, String var2, int var3);

    public List<UserNameModel> simpleSearchWithRoleNames(Collection<String> var1, Collection<String> var2, int var3);

    public List<UserNameModel> simpleSearchWithRoleNamesAndKeywordPrefix(Collection<String> var1, String var2, int var3);

    default public long countActivatedUsers() {
        return this.countUsersByStatus(UserStatus.ACTIVATED.toString());
    }
}

