/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.util;

import com.tvd12.ezyfox.io.EzyStrings;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class HttpServletRequests {
    private HttpServletRequests() {
    }

    public static String getRequestValue(HttpServletRequest request, String name) {
        return HttpServletRequests.getRequestValue(request, name, Boolean.TRUE);
    }

    public static String getRequestValue(HttpServletRequest request, String name, boolean checkCookie) {
        Cookie[] cookies;
        String value = request.getParameter(name);
        if (EzyStrings.isBlank((String)value)) {
            value = request.getHeader(name);
        }
        if (EzyStrings.isBlank((String)value)) {
            value = Objects.toString(request.getAttribute(name), null);
        }
        if (EzyStrings.isBlank((String)value) && checkCookie && (cookies = request.getCookies()) != null) {
            Cookie cookie;
            Cookie[] cookieArray = cookies;
            int n = cookieArray.length;
            for (int i = 0; !(i >= n || (cookie = cookieArray[i]).getName().equals(name) && EzyStrings.isNotBlank((String)(value = cookie.getValue()))); ++i) {
            }
        }
        return value;
    }

    public static String getRequestValueAnyway(HttpServletRequest request, String name) {
        return HttpServletRequests.getRequestValueAnyway(request, name, Boolean.TRUE);
    }

    public static String getRequestValueAnyway(HttpServletRequest request, String name, boolean checkCookie) {
        String value = HttpServletRequests.getRequestValue(request, name, checkCookie);
        String argumentNameLowerCase = "";
        if (EzyStrings.isBlank((String)value)) {
            argumentNameLowerCase = name.toLowerCase();
            value = HttpServletRequests.getRequestValue(request, argumentNameLowerCase, checkCookie);
        }
        if (EzyStrings.isBlank((String)value)) {
            String argumentNameFirstUpperCase = argumentNameLowerCase.substring(0, 1).toUpperCase() + argumentNameLowerCase.substring(1);
            value = HttpServletRequests.getRequestValue(request, argumentNameFirstUpperCase, checkCookie);
        }
        return value;
    }
}

