/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.database.bean;

import com.tvd12.ezydata.database.EzyDatabaseRepository;
import com.tvd12.ezydata.database.EzyDatabaseRepositoryWrapper;
import com.tvd12.ezydata.database.bean.EzyAbstractRepositoryImplementer;
import com.tvd12.ezydata.database.bean.EzyRepositoriesImplementer;
import com.tvd12.ezydata.database.query.EzyQueryMethodConverter;
import com.tvd12.ezydata.database.query.EzyQueryRegister;
import com.tvd12.ezyfox.annotation.EzyAutoImpl;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.database.annotation.EzyRepository;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EzyAbstractRepositoriesImplementer
extends EzyLoggable
implements EzyRepositoriesImplementer {
    protected Set<String> packagesToScan;
    protected Set<Class<?>> autoImplInterfaces;
    protected List<EzyReflection> reflections = new ArrayList<EzyReflection>();
    protected EzyQueryRegister queryManager;
    protected EzyQueryMethodConverter queryMethodConverter;
    protected EzyDatabaseRepositoryWrapper repositoryWrapper;

    public EzyAbstractRepositoriesImplementer() {
        this.packagesToScan = new HashSet<String>();
        this.autoImplInterfaces = new HashSet();
        this.repositoryWrapper = EzyDatabaseRepositoryWrapper.DEFAULT;
    }

    @Override
    public EzyRepositoriesImplementer scan(String packageName) {
        this.packagesToScan.add(packageName);
        return this;
    }

    @Override
    public EzyRepositoriesImplementer scan(String ... packageNames) {
        return this.scan(Sets.newHashSet((Object[])packageNames));
    }

    @Override
    public EzyRepositoriesImplementer scan(Iterable<String> packageNames) {
        for (String packageName : packageNames) {
            this.scan(packageName);
        }
        return this;
    }

    @Override
    public EzyRepositoriesImplementer repositoryInterface(Class<?> itf) {
        if (!Modifier.isInterface(itf.getModifiers())) {
            this.logger.warn("class {} is not an interface, ignore its", (Object)itf.getSimpleName());
        } else if (!this.getBaseRepositoryInterface().isAssignableFrom(itf)) {
            this.logger.warn("interface {} doesn't extends {}, ignore its", (Object)itf.getSimpleName(), (Object)this.getBaseRepositoryInterface().getSimpleName());
        } else {
            this.autoImplInterfaces.add(itf);
        }
        return this;
    }

    @Override
    public EzyRepositoriesImplementer repositoryInterfaces(Class<?> ... interfaces) {
        return this.repositoryInterfaces(Sets.newHashSet((Object[])interfaces));
    }

    @Override
    public EzyRepositoriesImplementer repositoryInterfaces(Iterable<Class<?>> interfaces) {
        for (Class<?> itf : interfaces) {
            this.repositoryInterface(itf);
        }
        return this;
    }

    @Override
    public EzyRepositoriesImplementer repositoryInterfaces(EzyReflection reflection) {
        if (reflection != null) {
            this.reflections.add(reflection);
        }
        return this;
    }

    @Override
    public EzyRepositoriesImplementer queryManager(EzyQueryRegister queryManager) {
        this.queryManager = queryManager;
        return this;
    }

    @Override
    public EzyRepositoriesImplementer queryMethodConverter(EzyQueryMethodConverter queryMethodConverter) {
        this.queryMethodConverter = queryMethodConverter;
        return this;
    }

    @Override
    public EzyRepositoriesImplementer repositoryWrapper(EzyDatabaseRepositoryWrapper repositoryWrapper) {
        this.repositoryWrapper = repositoryWrapper;
        return this;
    }

    @Override
    public Map<Class<?>, Object> implement(Object template) {
        Collection<Class<?>> scannedInterfaces = this.getAutoImplRepoInterfaces();
        this.autoImplInterfaces.addAll(scannedInterfaces);
        ConcurrentHashMap repositories = new ConcurrentHashMap();
        for (Class<?> itf : this.autoImplInterfaces) {
            Object repo = this.implementRepoInterface(itf, template);
            repositories.put(itf, repo);
        }
        return repositories;
    }

    private Object implementRepoInterface(Class<?> itf, Object template) {
        EzyAbstractRepositoryImplementer implementer = this.newRepoImplementer(itf);
        implementer.setQueryManager(this.queryManager);
        implementer.setQueryMethodConverter(this.queryMethodConverter);
        implementer.setRepositoryWrapper(this.repositoryWrapper);
        return implementer.implement(template);
    }

    protected abstract EzyAbstractRepositoryImplementer newRepoImplementer(Class<?> var1);

    private Collection<Class<?>> getAutoImplRepoInterfaces() {
        if (this.packagesToScan.size() > 0) {
            this.reflections.add((EzyReflection)new EzyReflectionProxy(this.packagesToScan));
        }
        HashSet classes = new HashSet();
        Class<?> baseInterface = this.getBaseRepositoryInterface();
        for (EzyReflection reflection : this.reflections) {
            classes.addAll(reflection.getExtendsClasses(baseInterface));
        }
        return EzySets.filter(classes, this::isAutoImplRepoInterface);
    }

    protected Class<?> getBaseRepositoryInterface() {
        return EzyDatabaseRepository.class;
    }

    private boolean isAutoImplRepoInterface(Class<?> clazz) {
        return (clazz.isAnnotationPresent(EzyAutoImpl.class) || clazz.isAnnotationPresent(EzyRepository.class)) && Modifier.isPublic(clazz.getModifiers()) && Modifier.isInterface(clazz.getModifiers());
    }
}

